/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.client;

import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.client.WSCPacketUpdateSign;
import com.degoos.wetsponge.util.Validate;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketUpdateSign;
import net.minecraft.util.math.BlockPos;

public class SpongeCPacketUpdateSign
extends SpongePacket
implements WSCPacketUpdateSign {
    private Vector3d position;
    private String[] lines;
    private boolean changed;

    public SpongeCPacketUpdateSign(Vector3d position, String[] lines) {
        super((Packet<?>)new CPacketUpdateSign());
        Validate.notNull(position, "Position cannot be null!");
        Validate.notNull(lines, "Lines cannot be null!");
        Validate.isTrue(lines.length > 3, "Lines must have 4 instances!");
        this.position = position;
        this.lines = (String[])lines.clone();
        this.update();
    }

    public SpongeCPacketUpdateSign(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].set(this.getHandler(), new BlockPos(this.position.getX(), this.position.getY(), this.position.getZ()));
            fields[1].set(this.getHandler(), this.lines);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            BlockPos blockPos = (BlockPos)fields[0].get(this.getHandler());
            this.position = new Vector3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            this.lines = (String[])fields[1].get(this.getHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d position) {
        Validate.notNull(position, "Position cannot be null!");
        this.position = position;
        this.changed = true;
    }

    @Override
    public String[] getLines() {
        return (String[])this.lines.clone();
    }

    @Override
    public void setLines(String[] lines) {
        Validate.notNull(lines, "Lines cannot be null!");
        Validate.isTrue(lines.length > 3, "Lines must have 4 instances!");
        this.lines = (String[])lines.clone();
        this.changed = true;
    }
}

