/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.client;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.client.WSCPacketPlayerTryUseItemOnBlock;
import com.flowpowered.math.vector.Vector3i;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class SpongeCPacketPlayerTryUseItemOnBlock
extends SpongePacket
implements WSCPacketPlayerTryUseItemOnBlock {
    private Vector3i position;
    private EnumBlockFace placedBlockDirection;
    private boolean mainHand;
    private float facingX;
    private float facingY;
    private float facingZ;
    private boolean changed;

    public SpongeCPacketPlayerTryUseItemOnBlock(Vector3i position, EnumBlockFace placedBlockDirection, boolean mainHand, float facingX, float facingY, float facingZ) {
        super((Packet<?>)new CPacketPlayerTryUseItemOnBlock());
        this.position = position;
        this.placedBlockDirection = placedBlockDirection;
        this.mainHand = mainHand;
        this.facingX = facingX;
        this.facingY = facingY;
        this.facingZ = facingZ;
        this.update();
    }

    public SpongeCPacketPlayerTryUseItemOnBlock(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public Vector3i getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3i position) {
        this.position = position;
        this.changed = true;
    }

    @Override
    public EnumBlockFace getPlacedBlockDirection() {
        return this.placedBlockDirection;
    }

    @Override
    public void setPlacedBlockDirection(EnumBlockFace direction) {
        this.placedBlockDirection = direction;
        this.changed = true;
    }

    @Override
    public boolean isMainHand() {
        return this.mainHand;
    }

    @Override
    public void setMainHand(boolean mainHand) {
        this.mainHand = mainHand;
        this.changed = true;
    }

    @Override
    public float getFacingX() {
        return this.facingX;
    }

    @Override
    public void setFacingX(float facingX) {
        this.facingX = facingX;
        this.changed = true;
    }

    @Override
    public float getFacingY() {
        return this.facingY;
    }

    @Override
    public void setFacingY(float facingY) {
        this.facingY = facingY;
        this.changed = true;
    }

    @Override
    public float getFacingZ() {
        return this.facingZ;
    }

    @Override
    public void setFacingZ(float facingZ) {
        this.facingZ = facingZ;
        this.changed = true;
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].set(this.getHandler(), new BlockPos(this.position.getX(), this.position.getY(), this.position.getZ()));
            fields[1].set(this.getHandler(), this.getEnumFacing(this.placedBlockDirection));
            fields[2].set(this.getHandler(), this.mainHand ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
            fields[3].setFloat(this.getHandler(), this.facingX);
            fields[4].setFloat(this.getHandler(), this.facingY);
            fields[5].setFloat(this.getHandler(), this.facingZ);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            BlockPos blockPos = (BlockPos)fields[0].get(this.getHandler());
            this.position = new Vector3i(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            this.placedBlockDirection = this.getEnumBlockDirection((EnumFacing)fields[1].get(this.getHandler()));
            this.mainHand = fields[2].get(this.getHandler()) == EnumHand.MAIN_HAND;
            this.facingX = fields[3].getFloat(this.getHandler());
            this.facingY = fields[4].getFloat(this.getHandler());
            this.facingZ = fields[5].getFloat(this.getHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    private EnumFacing getEnumFacing(EnumBlockFace direction) {
        switch (direction) {
            case DOWN: {
                return EnumFacing.DOWN;
            }
            case EAST: {
                return EnumFacing.EAST;
            }
            case NORTH: {
                return EnumFacing.NORTH;
            }
            case SOUTH: {
                return EnumFacing.SOUTH;
            }
            case UP: {
                return EnumFacing.UP;
            }
            case WEST: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.DOWN;
    }

    private EnumBlockFace getEnumBlockDirection(EnumFacing direction) {
        switch (direction) {
            case DOWN: {
                return EnumBlockFace.DOWN;
            }
            case EAST: {
                return EnumBlockFace.EAST;
            }
            case NORTH: {
                return EnumBlockFace.NORTH;
            }
            case SOUTH: {
                return EnumBlockFace.SOUTH;
            }
            case UP: {
                return EnumBlockFace.UP;
            }
            case WEST: {
                return EnumBlockFace.WEST;
            }
        }
        return EnumBlockFace.DOWN;
    }
}

