/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.client;

import com.degoos.wetsponge.enums.EnumEntityAction;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.client.WSCPacketEntityAction;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketEntityAction;

public class SpongeCPacketEntityAction
extends SpongePacket
implements WSCPacketEntityAction {
    private boolean changed;
    private int entityId;
    private int jumpBoost;
    private EnumEntityAction entityAction;

    public SpongeCPacketEntityAction(int entityId, EnumEntityAction entityAction, int jumpBoost) {
        super((Packet<?>)new CPacketEntityAction());
        this.entityId = entityId;
        this.entityAction = entityAction;
        this.jumpBoost = jumpBoost;
        this.update();
    }

    public SpongeCPacketEntityAction(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[2].setInt(this.getHandler(), this.jumpBoost);
            if (this.entityAction != null) {
                fields[1].set(this.getHandler(), CPacketEntityAction.Action.valueOf((String)this.entityAction.name()));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.entityAction = EnumEntityAction.getById(((CPacketEntityAction.Action)fields[1].get(this.getHandler())).ordinal()).orElse(null);
            this.jumpBoost = fields[2].getInt(this.getHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
        this.changed = true;
    }

    @Override
    public EnumEntityAction getAction() {
        return this.entityAction;
    }

    @Override
    public void setAction(EnumEntityAction entityAction) {
        this.entityAction = entityAction;
        this.changed = true;
    }

    @Override
    public int getJumpBoost() {
        return this.jumpBoost;
    }

    @Override
    public void setJumpBoost(int jumpBoost) {
        this.jumpBoost = jumpBoost;
        this.changed = true;
    }
}

