/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.client;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.packet.SpigotPacket;
import com.degoos.wetsponge.packet.play.client.WSCPacketPlayerTryUseItemOnBlock;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import com.flowpowered.math.vector.Vector3i;
import java.lang.reflect.Field;
import java.util.Arrays;

public class SpigotCPacketPlayerTryUseItemOnBlock
extends SpigotPacket
implements WSCPacketPlayerTryUseItemOnBlock {
    private Vector3i position;
    private EnumBlockFace placedBlockDirection;
    private boolean mainHand;
    private float facingX;
    private float facingY;
    private float facingZ;
    private boolean changed;

    public SpigotCPacketPlayerTryUseItemOnBlock(Vector3i position, EnumBlockFace placedBlockDirection, boolean mainHand, float facingX, float facingY, float facingZ) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayInUseItem").newInstance());
        this.position = position;
        this.placedBlockDirection = placedBlockDirection;
        this.mainHand = mainHand;
        this.facingX = facingX;
        this.facingY = facingY;
        this.facingZ = facingZ;
        this.update();
    }

    public SpigotCPacketPlayerTryUseItemOnBlock(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public Vector3i getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3i position) {
        this.position = position;
        this.changed = true;
    }

    @Override
    public EnumBlockFace getPlacedBlockDirection() {
        return this.placedBlockDirection;
    }

    @Override
    public void setPlacedBlockDirection(EnumBlockFace direction) {
        this.placedBlockDirection = direction;
        this.changed = true;
    }

    @Override
    public boolean isMainHand() {
        return this.mainHand;
    }

    @Override
    public void setMainHand(boolean mainHand) {
        this.mainHand = mainHand;
        this.changed = true;
    }

    @Override
    public float getFacingX() {
        return this.facingX;
    }

    @Override
    public void setFacingX(float facingX) {
        this.facingX = facingX;
        this.changed = true;
    }

    @Override
    public float getFacingY() {
        return this.facingY;
    }

    @Override
    public void setFacingY(float facingY) {
        this.facingY = facingY;
        this.changed = true;
    }

    @Override
    public float getFacingZ() {
        return this.facingZ;
    }

    @Override
    public void setFacingZ(float facingZ) {
        this.facingZ = facingZ;
        this.changed = true;
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].set(this.getHandler(), SpigotHandledUtils.getBlockPosition(this.position));
            fields[1].set(this.getHandler(), NMSUtils.getNMSClass("EnumDirection").getMethod("valueOf", String.class).invoke(null, this.placedBlockDirection.name()));
            fields[2].set(this.getHandler(), NMSUtils.getNMSClass("EnumHand").getMethod("valueOf", String.class).invoke(null, this.mainHand ? "MAIN_HAND" : "OFF_HAND"));
            fields[3].setFloat(this.getHandler(), this.facingX);
            fields[4].setFloat(this.getHandler(), this.facingY);
            fields[5].setFloat(this.getHandler(), this.facingZ);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.position = SpigotHandledUtils.getBlockPositionVector(fields[0].get(this.getHandler()));
            this.placedBlockDirection = EnumBlockFace.valueOf((String)NMSUtils.getNMSClass("EnumDirection").getMethod("name", new Class[0]).invoke(fields[1].get(this.getHandler()), new Object[0]));
            this.mainHand = NMSUtils.getNMSClass("EnumHand").getMethod("name", new Class[0]).invoke(fields[2].get(this.getHandler()), new Object[0]).equals("MAIN_HAND");
            this.facingX = fields[3].getFloat(this.getHandler());
            this.facingY = fields[4].getFloat(this.getHandler());
            this.facingZ = fields[5].getFloat(this.getHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

