/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.client;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.client.WSCPacketUpdateSign;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Spigot13CPacketUpdateSign
extends Spigot13Packet
implements WSCPacketUpdateSign {
    private Vector3d position;
    private String[] lines;
    private boolean changed;

    public Spigot13CPacketUpdateSign(Vector3d position, String[] lines) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayInUpdateSign").newInstance());
        Validate.notNull(position, "Position cannot be null!");
        Validate.notNull(lines, "Lines cannot be null!");
        Validate.isTrue(lines.length > 3, "Lines must have 4 instances!");
        this.position = position;
        this.lines = (String[])lines.clone();
        this.update();
    }

    public Spigot13CPacketUpdateSign(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].set(this.getHandler(), Spigot13HandledUtils.getBlockPosition(this.position));
            Object array = Array.newInstance(NMSUtils.getNMSClass("IChatBaseComponent"), 4);
            for (int i = 0; i < 4; ++i) {
                Array.set(array, i, NMSUtils.getNMSClass("TextComponent").getConstructor(String.class).newInstance(this.lines[i]));
            }
            fields[1].set(this.getHandler(), array);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            Object blockPos = fields[0].get(this.getHandler());
            this.position = new Vector3d(((Integer)blockPos.getClass().getMethod("getX", new Class[0]).invoke(blockPos, new Object[0])).intValue(), ((Integer)blockPos.getClass().getMethod("getY", new Class[0]).invoke(blockPos, new Object[0])).intValue(), ((Integer)blockPos.getClass().getMethod("getZ", new Class[0]).invoke(blockPos, new Object[0])).intValue());
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                this.lines = (String[])fields[1].get(this.getHandler());
            } else {
                this.lines = new String[4];
                Method textMethod = NMSUtils.getNMSClass("IChatBaseComponent").getMethod("getText", new Class[0]);
                Object[] array = (Object[])fields[1].get(this.getHandler());
                for (int i = 0; i < 4; ++i) {
                    this.lines[i] = (String)textMethod.invoke(array[i], new Object[0]);
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d position) {
        Validate.notNull(position, "Position cannot be null!");
        this.position = position;
        this.changed = true;
    }

    @Override
    public String[] getLines() {
        return (String[])this.lines.clone();
    }

    @Override
    public void setLines(String[] lines) {
        Validate.notNull(lines, "Lines cannot be null!");
        Validate.isTrue(lines.length > 3, "Lines must have 4 instances!");
        this.lines = (String[])lines.clone();
        this.changed = true;
    }
}

