/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.nbt;

import com.degoos.wetsponge.nbt.NBTTagUpdater;
import com.degoos.wetsponge.nbt.SpigotNBTBase;
import com.degoos.wetsponge.nbt.SpigotNBTTagByte;
import com.degoos.wetsponge.nbt.SpigotNBTTagByteArray;
import com.degoos.wetsponge.nbt.SpigotNBTTagDouble;
import com.degoos.wetsponge.nbt.SpigotNBTTagFloat;
import com.degoos.wetsponge.nbt.SpigotNBTTagInt;
import com.degoos.wetsponge.nbt.SpigotNBTTagIntArray;
import com.degoos.wetsponge.nbt.SpigotNBTTagLong;
import com.degoos.wetsponge.nbt.SpigotNBTTagParser;
import com.degoos.wetsponge.nbt.SpigotNBTTagShort;
import com.degoos.wetsponge.nbt.SpigotNBTTagString;
import com.degoos.wetsponge.nbt.WSNBTBase;
import com.degoos.wetsponge.nbt.WSNBTPrimitive;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.nbt.WSNBTTagList;
import com.degoos.wetsponge.nbt.WSNBTTagString;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public class SpigotNBTTagCompound
extends SpigotNBTBase
implements WSNBTTagCompound {
    private static final Class<?> clazz = NMSUtils.getNMSClass("NBTTagCompound");
    private Map map;

    public SpigotNBTTagCompound(String nbt) throws Exception {
        this(NMSUtils.getNMSClass("MojangsonParser").getMethod("parse", String.class).invoke(null, NBTTagUpdater.update(nbt)));
    }

    public SpigotNBTTagCompound(Object object) {
        super(object);
        try {
            this.map = ReflectionUtils.getFirstObject(clazz, Map.class, this.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An exception has occurred while WetSponge was initializing a NBTTagCompound!");
        }
    }

    public SpigotNBTTagCompound() throws IllegalAccessException, InstantiationException {
        this(clazz.newInstance());
    }

    @Override
    public Set<String> getKeySet() {
        return this.map.keySet();
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    @Override
    public void setTag(String key, WSNBTBase wsnbt) {
        this.map.put(key, wsnbt.getHandled());
    }

    @Override
    public void setByte(String key, byte b) {
        try {
            this.map.put(key, new SpigotNBTTagByte(b).getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was modifying a NBTTagCompound!");
            e.printStackTrace();
        }
    }

    @Override
    public void setShort(String key, short s2) {
        try {
            this.map.put(key, new SpigotNBTTagShort(s2).getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was modifying a NBTTagCompound!");
            e.printStackTrace();
        }
    }

    @Override
    public void setInteger(String key, int i) {
        try {
            this.map.put(key, new SpigotNBTTagInt(i).getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was modifying a NBTTagCompound!");
            e.printStackTrace();
        }
    }

    @Override
    public void setLong(String key, long l) {
        try {
            this.map.put(key, new SpigotNBTTagLong(l).getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was modifying a NBTTagCompound!");
            e.printStackTrace();
        }
    }

    @Override
    public void setUniqueId(String key, UUID uuid) {
        this.setLong(key + "Most", uuid.getMostSignificantBits());
        this.setLong(key + "Least", uuid.getLeastSignificantBits());
    }

    @Override
    public void setFloat(String key, float f) {
        try {
            this.map.put(key, new SpigotNBTTagFloat(f).getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was modifying a NBTTagCompound!");
            e.printStackTrace();
        }
    }

    @Override
    public void setDouble(String key, double d) {
        try {
            this.map.put(key, new SpigotNBTTagDouble(d).getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was modifying a NBTTagCompound!");
            e.printStackTrace();
        }
    }

    @Override
    public void setString(String key, String string) {
        try {
            this.map.put(key, new SpigotNBTTagString(string).getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was modifying a NBTTagCompound!");
            e.printStackTrace();
        }
    }

    @Override
    public void setByteArray(String key, byte[] bytes) {
        try {
            this.map.put(key, new SpigotNBTTagByteArray(bytes).getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was modifying a NBTTagCompound!");
            e.printStackTrace();
        }
    }

    @Override
    public void setIntArray(String key, int[] ints) {
        try {
            this.map.put(key, new SpigotNBTTagIntArray(ints).getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was modifying a NBTTagCompound!");
            e.printStackTrace();
        }
    }

    @Override
    public void setBoolean(String key, boolean b) {
        this.setByte(key, (byte)(b ? 1 : 0));
    }

    @Override
    public WSNBTBase getTag(String key) {
        return Optional.ofNullable(this.map.get(key)).map(SpigotNBTTagParser::parse).orElse(null);
    }

    @Override
    public byte getTagId(String key) {
        return Optional.ofNullable(this.getTag(key)).map(WSNBTBase::getId).orElse((byte)0);
    }

    @Override
    public boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean hasKeyOfType(String key, int id) {
        byte tagId = this.getTagId(key);
        if (tagId == id) {
            return true;
        }
        if (id != 99) {
            return false;
        }
        return tagId == 1 || tagId == 2 || tagId == 3 || tagId == 4 || tagId == 5 || tagId == 6;
    }

    @Override
    public byte getByte(String key) {
        try {
            if (this.hasKeyOfType(key, 99)) {
                return ((WSNBTPrimitive)this.getTag(key)).getByte();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public short getShort(String key) {
        try {
            if (this.hasKeyOfType(key, 99)) {
                return ((WSNBTPrimitive)this.getTag(key)).getShort();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public int getInteger(String key) {
        try {
            if (this.hasKeyOfType(key, 99)) {
                return ((WSNBTPrimitive)this.getTag(key)).getInt();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public long getLong(String key) {
        try {
            if (this.hasKeyOfType(key, 99)) {
                return ((WSNBTPrimitive)this.getTag(key)).getLong();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    @Override
    @Nullable
    public UUID getUniqueId(String key) {
        return new UUID(this.getLong(key + "Most"), this.getLong(key + "Least"));
    }

    @Override
    public boolean hasUniqueId(String key) {
        return this.hasKeyOfType(key + "Most", 99) && this.hasKeyOfType(key + "Least", 99);
    }

    @Override
    public float getFloat(String key) {
        try {
            if (this.hasKeyOfType(key, 99)) {
                return ((WSNBTPrimitive)this.getTag(key)).getFloat();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    @Override
    public double getDouble(String key) {
        try {
            if (this.hasKeyOfType(key, 99)) {
                return ((WSNBTPrimitive)this.getTag(key)).getDouble();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    @Override
    public String getString(String key) {
        try {
            if (this.hasKeyOfType(key, 8)) {
                return ((WSNBTTagString)this.getTag(key)).getString();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    @Override
    public byte[] getByteArray(String key) {
        try {
            return (byte[])ReflectionUtils.invokeMethod(this.getHandled(), "getByteArray", key);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting an array from a NBTTagCompound!");
            return new byte[0];
        }
    }

    @Override
    public int[] getIntArray(String key) {
        try {
            return (int[])ReflectionUtils.invokeMethod(this.getHandled(), "getIntArray", key);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting an array from a NBTTagCompound!");
            return new int[0];
        }
    }

    @Override
    public WSNBTTagCompound getCompoundTag(String key) {
        try {
            return new SpigotNBTTagCompound(ReflectionUtils.invokeMethod(this.getHandled(), "getCompound", key));
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting an array from a NBTTagCompound!");
            try {
                return new SpigotNBTTagCompound();
            }
            catch (Exception ex2) {
                InternalLogger.printException((Throwable)ex2, "An error has occurred while WetSponge was getting an array from a NBTTagCompound!");
                return null;
            }
        }
    }

    @Override
    public WSNBTTagList getTagList(String key, int expectedTagId) {
        return null;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getByte(key) != 0;
    }

    @Override
    public void removeTag(String key) {
        this.map.remove(key);
    }

    @Override
    public void merge(WSNBTTagCompound wsnbtTagCompound) {
        for (Object o : ((SpigotNBTTagCompound)wsnbtTagCompound).map.keySet()) {
            String key = (String)o;
            WSNBTBase wsnbtBase = wsnbtTagCompound.getTag(key);
            if (wsnbtBase.getId() == 10 && this.hasKeyOfType(key, 10)) {
                WSNBTTagCompound compound = this.getCompoundTag(key);
                compound.merge((WSNBTTagCompound)wsnbtBase);
                continue;
            }
            this.setTag(key, wsnbtBase.copy());
        }
    }

    @Override
    public WSNBTTagCompound copy() {
        try {
            SpigotNBTTagCompound compound = new SpigotNBTTagCompound();
            for (Object o : this.map.keySet()) {
                String key = (String)o;
                WSNBTBase tag = this.getTag(key);
                if (tag == null) continue;
                compound.setTag(key, tag.copy());
            }
            return compound;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was copying a NBTTagCompound!");
            return null;
        }
    }
}

