/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.nbt;

import com.degoos.wetsponge.nbt.WSNBTBase;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;

public abstract class SpigotNBTBase
implements WSNBTBase {
    private Object nbtBase;
    private static final Class<?> clazz = NMSUtils.getNMSClass("NBTBase");

    public SpigotNBTBase(Object nbtBase) {
        this.nbtBase = nbtBase;
    }

    @Override
    public byte getId() {
        try {
            return (Byte)ReflectionUtils.invokeMethod(this.nbtBase, clazz, "getTypeId", new Object[0]);
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was getting a NBTTag id!");
            return 0;
        }
    }

    @Override
    public abstract WSNBTBase copy();

    @Override
    public boolean hasNoTags() {
        try {
            return (Boolean)ReflectionUtils.invokeMethod(this.nbtBase, clazz, "isEmpty", new Object[0]);
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was checking if a NBTTag has no tags!");
            return true;
        }
    }

    @Override
    public String toString() {
        return this.nbtBase == null ? super.toString() : this.nbtBase.toString();
    }

    @Override
    public Object getHandled() {
        return this.nbtBase;
    }
}

