/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.nbt;

import com.degoos.wetsponge.nbt.Spigot13NBTBase;
import com.degoos.wetsponge.nbt.WSNBTTagInt;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;

public class Spigot13NBTTagInt
extends Spigot13NBTBase
implements WSNBTTagInt {
    private static final Class<?> clazz = NMSUtils.getNMSClass("NBTTagInt");

    public Spigot13NBTTagInt(int i) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this(clazz.getConstructor(Integer.TYPE).newInstance(i));
    }

    public Spigot13NBTTagInt(Object object) {
        super(object);
    }

    private int getValue() {
        try {
            return ReflectionUtils.getFirstObject(clazz, Integer.TYPE, this.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was getting the value of a NBTTag!");
            return 0;
        }
    }

    @Override
    public long getLong() {
        return this.getValue();
    }

    @Override
    public int getInt() {
        return this.getValue();
    }

    @Override
    public short getShort() {
        return (short)this.getValue();
    }

    @Override
    public byte getByte() {
        return (byte)(this.getValue() & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.getValue();
    }

    @Override
    public float getFloat() {
        return this.getValue();
    }

    @Override
    public WSNBTTagInt copy() {
        try {
            return new Spigot13NBTTagInt(this.getValue());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was copying a NBTTag!");
            return null;
        }
    }

    @Override
    public Object getHandled() {
        return super.getHandled();
    }
}

