/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.nbt;

import com.degoos.wetsponge.nbt.Spigot13NBTBase;
import com.degoos.wetsponge.nbt.WSNBTTagByte;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;

public class Spigot13NBTTagByte
extends Spigot13NBTBase
implements WSNBTTagByte {
    private static final Class<?> clazz = NMSUtils.getNMSClass("NBTTagByte");

    public Spigot13NBTTagByte(byte b) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this(clazz.getConstructor(Byte.TYPE).newInstance(b));
    }

    public Spigot13NBTTagByte(Object object) {
        super(object);
    }

    private byte getValue() {
        try {
            return ReflectionUtils.getFirstObject(clazz, Byte.TYPE, this.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was getting the value of a NBTTag!");
            return 0;
        }
    }

    @Override
    public long getLong() {
        return this.getValue();
    }

    @Override
    public int getInt() {
        return this.getValue();
    }

    @Override
    public short getShort() {
        return this.getValue();
    }

    @Override
    public byte getByte() {
        return this.getValue();
    }

    @Override
    public double getDouble() {
        return this.getValue();
    }

    @Override
    public float getFloat() {
        return this.getValue();
    }

    @Override
    public WSNBTTagByte copy() {
        try {
            return new Spigot13NBTTagByte(this.getValue());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was copying a NBTTag!");
            return null;
        }
    }

    @Override
    public Object getHandled() {
        return super.getHandled();
    }
}

