/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.mixin.sponge.mixin;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.data.WSTransaction;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.event.entity.player.WSPlayerChangeHotbarSlotEvent;
import com.degoos.wetsponge.event.entity.player.WSPlayerSwapHandItemsEvent;
import com.degoos.wetsponge.item.SpongeItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.packet.play.server.WSSPacketHeldItemChange;
import com.degoos.wetsponge.parser.player.PlayerParser;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.util.EnumHand;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetHandlerPlayServer.class}, priority=0x7FFFFFFF)
public class MixinNetHandlerPlayServer {
    @Shadow
    public EntityPlayerMP field_147369_b;
    public WSPlayer wsPlayer = null;

    @Inject(method={"processPlayerDigging"}, at={@At(value="HEAD")}, cancellable=true)
    public void processPlayerDigging(CPacketPlayerDigging packetPlayerDigging, CallbackInfo callbackInfo) {
        if (packetPlayerDigging.func_180762_c().equals((Object)CPacketPlayerDigging.Action.SWAP_HELD_ITEMS)) {
            WSPlayer player = this.wsPlayer == null ? (this.wsPlayer = (WSPlayer)PlayerParser.getPlayer(this.field_147369_b.func_110124_au()).orElse(null)) : this.wsPlayer;
            WSItemStack offHand = player.getEquippedItem(EnumEquipType.OFF_HAND).orElse(null);
            WSItemStack mainHand = player.getEquippedItem(EnumEquipType.MAIN_HAND).orElse(null);
            WSPlayerSwapHandItemsEvent event = new WSPlayerSwapHandItemsEvent(player, new WSTransaction<WSItemStack>(mainHand, offHand), new WSTransaction<WSItemStack>(offHand, mainHand));
            WetSponge.getEventManager().callEvent(event);
            if (event.isCancelled()) {
                callbackInfo.cancel();
                return;
            }
            if (!this.field_147369_b.func_175149_v()) {
                WSItemStack main = event.getMainHand().getNewData();
                WSItemStack off = event.getOffHand().getNewData();
                if (main == null) {
                    this.field_147369_b.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                } else {
                    this.field_147369_b.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)((SpongeItemStack)main).getHandled());
                }
                if (off == null) {
                    this.field_147369_b.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                } else {
                    this.field_147369_b.func_184611_a(EnumHand.OFF_HAND, (ItemStack)((SpongeItemStack)off).getHandled());
                }
            }
            callbackInfo.cancel();
        }
    }

    @Inject(method={"processHeldItemChange"}, at={@At(value="HEAD")}, cancellable=true)
    public void onProcessHeldItemChange(CPacketHeldItemChange packet, CallbackInfo callbackInfo) {
        WSPlayer player = this.wsPlayer == null ? (this.wsPlayer = (WSPlayer)PlayerParser.getPlayer(this.field_147369_b.func_110124_au()).orElse(null)) : this.wsPlayer;
        WSPlayerChangeHotbarSlotEvent event = new WSPlayerChangeHotbarSlotEvent(player, player.getSelectedHotbarSlot(), packet.func_149614_c());
        WetSponge.getEventManager().callEvent(event);
        if (event.isCancelled()) {
            player.sendPacket(WSSPacketHeldItemChange.of(player.getSelectedHotbarSlot()));
            this.field_147369_b.func_143004_u();
            callbackInfo.cancel();
        }
    }
}

