/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.mixin.sponge.mixin;

import com.degoos.wetsponge.mixin.sponge.interfaces.WSMixinChunk;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.world.SpongeWorld;
import com.degoos.wetsponge.world.WSChunkLoaderSavable;
import com.degoos.wetsponge.world.WSWorld;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AnvilChunkLoader.class}, priority=0x7FFFFFFF)
public abstract class MixinAnvilChunkLoader
implements WSChunkLoaderSavable {
    private Set<World> worlds = new HashSet<World>();
    @Shadow
    @Final
    private DataFixer field_193416_e;
    @Shadow
    @Final
    private File field_75825_d;
    @Shadow
    @Final
    private Map<ChunkPos, NBTTagCompound> field_75828_a;

    @Shadow
    private void func_75820_a(Chunk chunkIn, World worldIn, NBTTagCompound nbtTagCompound) {
    }

    @Shadow
    protected abstract void func_75824_a(ChunkPos var1, NBTTagCompound var2);

    @Shadow
    public abstract boolean func_75814_c();

    @Shadow
    protected abstract Chunk func_75822_a(World var1, int var2, int var3, NBTTagCompound var4);

    @Overwrite
    public void func_75816_a(World worldIn, Chunk chunkIn) throws MinecraftException, IOException {
        if (((WSMixinChunk)chunkIn).isPreparedToCancelUnload()) {
            return;
        }
        if (((WSMixinChunk)chunkIn).canBeSaved() && !this.worlds.contains(worldIn)) {
            worldIn.func_72906_B();
            try {
                NBTTagCompound exception = new NBTTagCompound();
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                exception.func_74782_a("Level", (NBTBase)nbttagcompound1);
                exception.func_74768_a("DataVersion", 922);
                this.func_75820_a(chunkIn, worldIn, nbttagcompound1);
                this.func_75824_a(chunkIn.func_76632_l(), exception);
            }
            catch (Throwable var5) {
                InternalLogger.sendError("Minecraft -> Failed to save chunk");
                var5.printStackTrace();
            }
        }
    }

    @Overwrite
    public void func_75819_b(World worldIn, Chunk chunkIn) {
    }

    @Override
    public boolean canSaveChunks(WSWorld world) {
        return !this.worlds.contains(world.getHandled());
    }

    @Override
    public void setSaveChunks(boolean saveChunks, WSWorld world) {
        if (saveChunks) {
            this.worlds.remove(world.getHandled());
        } else {
            this.worlds.add((World)((SpongeWorld)world).getHandled());
        }
    }

    @Override
    public void saveAllChunks(WSWorld wsWorld) {
        Validate.notNull(wsWorld, "World cannot be null!");
        World world = (World)wsWorld.getHandled();
        ((ChunkProviderServer)world.func_72863_F()).func_189548_a().forEach(chunk -> {
            try {
                this.func_75816_a(world, (Chunk)chunk);
            }
            catch (Exception e) {
                InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was trying to save the chunks of the world" + wsWorld.getName());
            }
        });
        while (this.func_75814_c()) {
        }
    }

    @Override
    public Chunk loadVanillaChunk(World world, int chunkX, int chunkZ) throws IOException {
        ChunkPos lvt_4_1_ = new ChunkPos(chunkX, chunkZ);
        NBTTagCompound lvt_5_1_ = this.field_75828_a.get(lvt_4_1_);
        if (lvt_5_1_ == null) {
            DataInputStream lvt_6_1_ = RegionFileCache.func_76549_c((File)this.field_75825_d, (int)chunkX, (int)chunkZ);
            if (lvt_6_1_ == null) {
                return null;
            }
            lvt_5_1_ = this.field_193416_e.func_188257_a((IFixType)FixTypes.CHUNK, CompressedStreamTools.func_74794_a((DataInputStream)lvt_6_1_));
        }
        return this.func_75822_a(world, chunkX, chunkZ, lvt_5_1_);
    }
}

