/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.merchant;

import com.degoos.wetsponge.item.Spigot13ItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.merchant.WSTrade;
import com.degoos.wetsponge.util.Validate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class Spigot13Trade
implements WSTrade {
    private MerchantRecipe trade;

    public Spigot13Trade(MerchantRecipe trade) {
        this.trade = trade;
    }

    @Override
    public int getUses() {
        return this.trade.getUses();
    }

    @Override
    public int getMaxUses() {
        return this.trade.getMaxUses();
    }

    @Override
    public WSItemStack getResult() {
        return new Spigot13ItemStack(this.trade.getResult()).clone();
    }

    @Override
    public WSItemStack getFirstItem() {
        return new Spigot13ItemStack((ItemStack)this.trade.getIngredients().get(0)).clone();
    }

    @Override
    public Optional<WSItemStack> getSecondItem() {
        return this.trade.getIngredients().size() == 2 && ((ItemStack)this.trade.getIngredients().get(1)).getType() != Material.AIR ? Optional.of(new Spigot13ItemStack((ItemStack)this.trade.getIngredients().get(1)).clone()) : Optional.empty();
    }

    @Override
    public boolean doesGrantExperience() {
        return this.trade.hasExperienceReward();
    }

    public MerchantRecipe getHandled() {
        return this.trade;
    }

    public static class Builder
    implements WSTrade.Builder {
        private int uses;
        private int maxUses;
        private WSItemStack result;
        private WSItemStack firstItem;
        private WSItemStack secondItem;
        private boolean grantExperience;

        @Override
        public WSTrade.Builder uses(int uses) {
            this.uses = uses;
            return this;
        }

        @Override
        public WSTrade.Builder maxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        @Override
        public WSTrade.Builder result(WSItemStack result) {
            Validate.notNull(result, "Result cannot be null!");
            this.result = result;
            return this;
        }

        @Override
        public WSTrade.Builder firstItem(WSItemStack firstItem) {
            Validate.notNull(firstItem, "First item cannot be null!");
            this.firstItem = firstItem;
            return this;
        }

        @Override
        public WSTrade.Builder secondItem(WSItemStack secondItem) {
            this.secondItem = secondItem;
            return this;
        }

        @Override
        public WSTrade.Builder canGrantExperience(boolean grantExperience) {
            this.grantExperience = grantExperience;
            return this;
        }

        @Override
        public WSTrade build() {
            Validate.notNull(this.result, "Result cannot be null!");
            Validate.notNull(this.firstItem, "First item cannot be null!");
            MerchantRecipe merchantRecipe = new MerchantRecipe(((Spigot13ItemStack)this.result).getHandled(), this.maxUses);
            merchantRecipe.setUses(this.uses);
            merchantRecipe.setExperienceReward(this.grantExperience);
            merchantRecipe.setIngredients(this.secondItem == null ? Collections.singletonList(((Spigot13ItemStack)this.firstItem).getHandled()) : Arrays.asList(((Spigot13ItemStack)this.firstItem).getHandled(), ((Spigot13ItemStack)this.secondItem).getHandled()));
            return new Spigot13Trade(merchantRecipe);
        }
    }
}

