/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.merchant;

import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.merchant.WSTrade;
import com.degoos.wetsponge.util.Validate;
import java.util.Optional;

public class OldSpigotTrade
implements WSTrade {
    private int uses;
    private int maxUses;
    private WSItemStack result;
    private WSItemStack firstItem;
    private WSItemStack secondItem;
    private boolean grantExperience;

    public OldSpigotTrade(int uses, int maxUses, WSItemStack result, WSItemStack firstItem, WSItemStack secondItem, boolean grantExperience) {
        Validate.notNull(result, "Result cannot be null!");
        Validate.notNull(firstItem, "First item cannot be null!");
        this.uses = uses;
        this.maxUses = maxUses;
        this.result = result;
        this.firstItem = firstItem;
        this.secondItem = secondItem;
        this.grantExperience = grantExperience;
    }

    @Override
    public int getUses() {
        return this.uses;
    }

    @Override
    public int getMaxUses() {
        return this.maxUses;
    }

    @Override
    public WSItemStack getResult() {
        return this.result.clone();
    }

    @Override
    public WSItemStack getFirstItem() {
        return this.firstItem.clone();
    }

    @Override
    public Optional<WSItemStack> getSecondItem() {
        return Optional.ofNullable(this.secondItem).map(WSItemStack::clone);
    }

    @Override
    public boolean doesGrantExperience() {
        return this.grantExperience;
    }

    @Override
    public Object getHandled() {
        return null;
    }

    public static class Builder
    implements WSTrade.Builder {
        private int uses;
        private int maxUses;
        private WSItemStack result;
        private WSItemStack firstItem;
        private WSItemStack secondItem;
        boolean grantExperience;

        @Override
        public WSTrade.Builder uses(int uses) {
            this.uses = uses;
            return this;
        }

        @Override
        public WSTrade.Builder maxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        @Override
        public WSTrade.Builder result(WSItemStack result) {
            Validate.notNull(result, "Result cannot be null!");
            this.result = result;
            return this;
        }

        @Override
        public WSTrade.Builder firstItem(WSItemStack firstItem) {
            Validate.notNull(firstItem, "First item cannot be null!");
            this.firstItem = firstItem;
            return this;
        }

        @Override
        public WSTrade.Builder secondItem(WSItemStack secondItem) {
            this.secondItem = secondItem == null || secondItem.getMaterial().getNumericalId() == 0 ? null : secondItem;
            return this;
        }

        @Override
        public WSTrade.Builder canGrantExperience(boolean grantExperience) {
            this.grantExperience = grantExperience;
            return this;
        }

        @Override
        public WSTrade build() {
            Validate.notNull(this.result, "Result cannot be null!");
            Validate.notNull(this.firstItem, "First item cannot be null!");
            return new OldSpigotTrade(this.uses, this.maxUses, this.result, this.firstItem, this.secondItem, this.grantExperience);
        }
    }
}

