/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.enums.item.EnumItemTypeBookGeneration;
import com.degoos.wetsponge.material.item.WSItemType;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.nbt.WSNBTTagList;
import com.degoos.wetsponge.nbt.WSNBTTagString;
import com.degoos.wetsponge.text.WSText;
import java.util.ArrayList;
import java.util.List;

public interface WSItemTypeWrittenBook
extends WSItemType {
    public WSText getAuthor();

    public WSItemTypeWrittenBook setAuthor(WSText var1);

    public WSText getTitle();

    public WSItemTypeWrittenBook setTitle(WSText var1);

    public List<WSText> getPages();

    public WSItemTypeWrittenBook addPage(WSText var1);

    public WSItemTypeWrittenBook setPages(List<WSText> var1);

    public EnumItemTypeBookGeneration getGeneration();

    public void setGeneration(EnumItemTypeBookGeneration var1);

    @Override
    public WSItemTypeWrittenBook clone();

    @Override
    default public WSNBTTagCompound writeToData(WSNBTTagCompound compound) {
        compound.setString("author", this.getAuthor().toFormattingText());
        compound.setString("title", this.getTitle().toFormattingText());
        compound.setString("generation", this.getGeneration().name());
        WSNBTTagList list = WSNBTTagList.of();
        this.getPages().forEach(target -> list.appendTag(WSNBTTagString.of(target.toFormattingText())));
        compound.setTag("pages", list);
        return compound;
    }

    @Override
    default public WSNBTTagCompound readFromData(WSNBTTagCompound compound) {
        this.setAuthor(WSText.getByFormattingText(compound.getString("author")));
        this.setTitle(WSText.getByFormattingText(compound.getString("title")));
        this.setGeneration(EnumItemTypeBookGeneration.valueOf(compound.getString("generation")));
        WSNBTTagList list = compound.getTagList("pages", 8);
        ArrayList<WSText> pages = new ArrayList<WSText>();
        for (int i = 0; i < list.tagCount(); ++i) {
            pages.add(WSText.getByFormattingText(list.getStringAt(i)));
        }
        this.setPages(pages);
        return compound;
    }
}

