/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeSkullType;
import com.degoos.wetsponge.material.item.WSItemType;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.nbt.WSNBTTagList;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.user.WSProfileProperty;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;

public interface WSItemTypeSkull
extends WSItemType {
    public Optional<WSGameProfile> getProfile();

    public void setProfile(WSGameProfile var1);

    public void setTexture(String var1);

    public void setTexture(URL var1);

    public void setTextureByPlayerName(String var1);

    public void findFormatAndSetTexture(String var1);

    public EnumBlockTypeSkullType getSkullType();

    public void setSkullType(EnumBlockTypeSkullType var1);

    @Override
    public WSItemTypeSkull clone();

    @Override
    default public WSNBTTagCompound writeToData(WSNBTTagCompound compound) {
        compound.setString("skullType", this.getSkullType().name());
        WSGameProfile gameProfile = this.getProfile().orElse(null);
        if (gameProfile == null) {
            return compound;
        }
        WSNBTTagCompound profileCompound = WSNBTTagCompound.of();
        profileCompound.setUniqueId("id", gameProfile.getId());
        gameProfile.getName().ifPresent(target -> profileCompound.setString("name", (String)target));
        WSNBTTagCompound properties = WSNBTTagCompound.of();
        gameProfile.getPropertyMap().keys().forEach(target -> {
            Collection<WSProfileProperty> collection = gameProfile.getPropertyMap().get((String)target);
            WSNBTTagList list = WSNBTTagList.of();
            collection.forEach(property -> {
                WSNBTTagCompound propertyCompound = WSNBTTagCompound.of();
                profileCompound.setString("value", property.getValue());
                property.getSignature().ifPresent(signature -> profileCompound.setString("signature", (String)signature));
                list.appendTag(propertyCompound);
            });
            properties.setTag((String)target, list);
        });
        profileCompound.setTag("properties", properties);
        compound.setTag("profile", profileCompound);
        return compound;
    }

    @Override
    default public WSNBTTagCompound readFromData(WSNBTTagCompound compound) {
        this.setSkullType(EnumBlockTypeSkullType.valueOf(compound.getString("skullType")));
        if (!compound.hasKey("profile")) {
            this.setProfile(null);
            return compound;
        }
        WSNBTTagCompound profileCompound = (WSNBTTagCompound)compound.getTag("profile");
        UUID uuid = profileCompound.getUniqueId("id");
        String name = profileCompound.hasKey("name") ? null : profileCompound.getString("name");
        WSGameProfile profile = WSGameProfile.of(uuid, name);
        this.setProfile(profile);
        WSNBTTagCompound properties = (WSNBTTagCompound)profileCompound.getTag("properties");
        properties.getKeySet().forEach(target -> {
            WSNBTTagList list = properties.getTagList((String)target, 10);
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.tagCount(); ++i) {
                WSNBTTagCompound propertyCompound = list.getCompoundTagAt(i);
                if (propertyCompound == null) {
                    return;
                }
                profile.addProperty((String)target, WSProfileProperty.of(target, propertyCompound.getString("value"), propertyCompound.hasKey("signature") ? null : propertyCompound.getString("signature")));
            }
        });
        return compound;
    }
}

