/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.color.WSColor;
import com.degoos.wetsponge.material.item.SpongeItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeMap;
import java.util.Objects;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeItemTypeMap
extends SpongeItemType
implements WSItemTypeMap {
    private int mapId;
    private WSColor color;

    public SpongeItemTypeMap(int mapId, WSColor color) {
        super(358, "minecraft:filled_map", "minecraft:filled_map", 1);
        this.mapId = mapId;
        this.color = color;
    }

    @Override
    public int getMapId() {
        return this.mapId;
    }

    @Override
    public void setMapId(int mapId) {
        this.mapId = Math.max(0, mapId);
    }

    @Override
    public WSColor getMapColor() {
        return this.color;
    }

    @Override
    public void setMapColor(WSColor mapColor) {
        this.color = mapColor;
    }

    @Override
    public SpongeItemTypeMap clone() {
        return new SpongeItemTypeMap(this.mapId, this.color);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        ((net.minecraft.item.ItemStack)itemStack).func_77964_b(this.mapId);
        return itemStack;
    }

    @Override
    public SpongeItemTypeMap readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        if (valueContainer instanceof ItemStack) {
            this.mapId = ((net.minecraft.item.ItemStack)valueContainer).func_77952_i();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeItemTypeMap that = (SpongeItemTypeMap)o;
        return this.mapId == that.mapId && Objects.equals(this.color, that.color);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mapId, this.color);
    }
}

