/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.enums.item.EnumItemTypeFishType;
import com.degoos.wetsponge.material.item.SpongeItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeFishBucket;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;

public class SpongeItemTypeFishBucket
extends SpongeItemType
implements WSItemTypeFishBucket {
    private EnumItemTypeFishType fishType;

    public SpongeItemTypeFishBucket(EnumItemTypeFishType fishType) {
        super(-1, "minecraft:cod_bucket", "minecraft:cod_bucket", 1);
        Validate.notNull((Object)fishType, "Fish type cannot be null!");
        this.fishType = fishType;
    }

    @Override
    public String getNewStringId() {
        switch (this.fishType) {
            case SALMON: {
                return "minecraft:salmon_bucket";
            }
            case PUFFERFISH: {
                return "minecraft:pufferfish_bucket";
            }
            case TROPICAL_FISH: {
                return "minecraft:tropical_fish_bucket";
            }
        }
        return "minecraft:cod_bucket";
    }

    @Override
    public EnumItemTypeFishType getFishType() {
        return this.fishType;
    }

    @Override
    public void setFishType(EnumItemTypeFishType fishType) {
        Validate.notNull((Object)fishType, "Fish type cannot be null!");
        this.fishType = fishType;
    }

    @Override
    public SpongeItemTypeFishBucket clone() {
        return new SpongeItemTypeFishBucket(this.fishType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeItemTypeFishBucket that = (SpongeItemTypeFishBucket)o;
        return this.fishType == that.fishType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.fishType});
    }
}

