/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.material.item.SpongeItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeDamageable;
import java.util.Objects;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeItemTypeDamageable
extends SpongeItemType
implements WSItemTypeDamageable {
    private int damage;
    private int maxUses;

    public SpongeItemTypeDamageable(int numericalId, String oldStringId, String newStringId, int damage, int maxUses) {
        super(numericalId, oldStringId, newStringId, 1);
        this.damage = damage;
        this.maxUses = maxUses;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public void setDamage(int damage) {
        this.damage = damage;
    }

    @Override
    public int getMaxUses() {
        return this.maxUses;
    }

    @Override
    public SpongeItemTypeDamageable clone() {
        return new SpongeItemTypeDamageable(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.damage, this.maxUses);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.ITEM_DURABILITY, (Object)this.damage);
        return itemStack;
    }

    @Override
    public SpongeItemTypeDamageable readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.damage = valueContainer.get(Keys.ITEM_DURABILITY).orElse(0);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeItemTypeDamageable that = (SpongeItemTypeDamageable)o;
        return this.damage == that.damage && this.maxUses == that.maxUses;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.damage, this.maxUses);
    }
}

