/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.enums.item.EnumItemTypeBookGeneration;
import com.degoos.wetsponge.material.item.SpigotItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeWrittenBook;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SpigotItemTypeWrittenBook
extends SpigotItemType
implements WSItemTypeWrittenBook {
    private WSText title;
    private WSText author;
    private List<WSText> pages;
    private EnumItemTypeBookGeneration generation;

    public SpigotItemTypeWrittenBook(int id, String stringId, String stringId13, WSText title, WSText author, List<WSText> pages, EnumItemTypeBookGeneration generation) {
        super(id, stringId, stringId13, 1);
        Validate.notNull((Object)generation, "Generation cannot be null!");
        this.title = title;
        this.author = author;
        this.pages = pages == null ? new ArrayList() : pages;
        this.generation = generation;
    }

    @Override
    public WSText getAuthor() {
        return this.author;
    }

    @Override
    public WSItemTypeWrittenBook setAuthor(WSText author) {
        this.author = author;
        return this;
    }

    @Override
    public WSText getTitle() {
        return this.title;
    }

    @Override
    public WSItemTypeWrittenBook setTitle(WSText title) {
        this.title = title;
        return this;
    }

    @Override
    public List<WSText> getPages() {
        return this.pages;
    }

    @Override
    public WSItemTypeWrittenBook addPage(WSText pageText) {
        this.pages.add(pageText);
        return this;
    }

    @Override
    public WSItemTypeWrittenBook setPages(List<WSText> pages) {
        this.pages = pages;
        return this;
    }

    @Override
    public EnumItemTypeBookGeneration getGeneration() {
        return this.generation;
    }

    @Override
    public void setGeneration(EnumItemTypeBookGeneration generation) {
        Validate.notNull((Object)generation, "Generation cannot be null!");
        this.generation = generation;
    }

    @Override
    public SpigotItemTypeWrittenBook clone() {
        return new SpigotItemTypeWrittenBook(this.getNumericalId(), this.getStringId(), this.getStringId(), this.title, this.author, new ArrayList<WSText>(this.pages), this.generation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotItemTypeWrittenBook that = (SpigotItemTypeWrittenBook)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.author, that.author) && Objects.equals(this.pages, that.pages) && this.generation == that.generation;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.title, this.author, this.pages, this.generation});
    }
}

