/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.firework.SpigotFireworkEffect;
import com.degoos.wetsponge.firework.WSFireworkEffect;
import com.degoos.wetsponge.material.item.SpigotItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeFireworkCharge;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SpigotItemTypeFireworkCharge
extends SpigotItemType
implements WSItemTypeFireworkCharge {
    private WSFireworkEffect effect;

    public SpigotItemTypeFireworkCharge(WSFireworkEffect effect) {
        super(402, "minecraft:firework_charge", "minecraft:firework_star", 64);
        this.effect = effect;
    }

    @Override
    public Optional<WSFireworkEffect> getEffect() {
        return Optional.ofNullable(this.effect);
    }

    @Override
    public void setEffect(WSFireworkEffect effect) {
        this.effect = effect;
    }

    @Override
    public SpigotItemTypeFireworkCharge clone() {
        return new SpigotItemTypeFireworkCharge(this.effect == null ? null : this.effect.clone());
    }

    @Override
    public void writeItemMeta(ItemMeta itemMeta) {
        super.writeItemMeta(itemMeta);
        if (itemMeta instanceof FireworkEffectMeta) {
            ((FireworkEffectMeta)itemMeta).setEffect(this.effect == null ? null : (FireworkEffect)this.effect.getHandled());
        }
    }

    @Override
    public void readItemMeta(ItemMeta itemMeta) {
        super.readItemMeta(itemMeta);
        if (itemMeta instanceof FireworkEffectMeta) {
            this.effect = Optional.ofNullable(((FireworkEffectMeta)itemMeta).getEffect()).map(SpigotFireworkEffect::new).orElse(null);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotItemTypeFireworkCharge that = (SpigotItemTypeFireworkCharge)o;
        return Objects.equals(this.effect, that.effect);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.effect);
    }
}

