/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.EnumDyeColor;
import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.type.WSBlockTypeDyeColored;
import com.degoos.wetsponge.material.block.type.WSBlockTypeGlassPane;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.nbt.WSNBTTagList;
import com.degoos.wetsponge.nbt.WSNBTTagString;

public interface WSBlockTypeStainedGlassPane
extends WSBlockTypeGlassPane,
WSBlockTypeDyeColored {
    @Override
    public WSBlockTypeStainedGlassPane clone();

    @Override
    default public WSNBTTagCompound writeToData(WSNBTTagCompound compound) {
        compound.setBoolean("waterlogged", this.isWaterlogged());
        WSNBTTagList list = WSNBTTagList.of();
        this.getFaces().forEach(target -> list.appendTag(WSNBTTagString.of(target.name())));
        compound.setTag("faces", list);
        compound.setString("color", this.getDyeColor().name());
        return compound;
    }

    @Override
    default public WSNBTTagCompound readFromData(WSNBTTagCompound compound) {
        this.setWaterlogged(compound.getBoolean("waterlogged"));
        this.getFaces().forEach(target -> this.setFace((EnumBlockFace)((Object)target), false));
        WSNBTTagList list = compound.getTagList("faces", 8);
        for (int i = 0; i < list.tagCount(); ++i) {
            this.setFace(EnumBlockFace.valueOf(list.getStringAt(i)), true);
        }
        this.setDyeColor(EnumDyeColor.valueOf(compound.getString("color")));
        return compound;
    }
}

