/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumWoodType;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeWoodPlanks;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.TreeType;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeWoodPlanks
extends SpongeBlockType
implements WSBlockTypeWoodPlanks {
    private EnumWoodType woodType;

    public SpongeBlockTypeWoodPlanks(EnumWoodType woodType) {
        super(5, "minecraft:planks", "minecraft:planks", 64);
        Validate.notNull((Object)woodType, "Wood type cannot be null!");
        this.woodType = woodType;
    }

    @Override
    public String getNewStringId() {
        switch (this.getWoodType()) {
            case SPRUCE: {
                return "minecraft:spruce_planks";
            }
            case BIRCH: {
                return "minecraft:birch_planks";
            }
            case JUNGLE: {
                return "minecraft:jungle_planks";
            }
            case ACACIA: {
                return "minecraft:acacia_planks";
            }
            case DARK_OAK: {
                return "minecraft:dark_oak_planks";
            }
        }
        return "minecraft:oak_planks";
    }

    @Override
    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public void setWoodType(EnumWoodType woodType) {
        Validate.notNull((Object)woodType, "Wood type cannot be null");
        this.woodType = woodType;
    }

    @Override
    public SpongeBlockTypeWoodPlanks clone() {
        return new SpongeBlockTypeWoodPlanks(this.woodType);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.TREE_TYPE, Sponge.getRegistry().getType(TreeType.class, this.woodType.name()).orElseThrow(NullPointerException::new));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.TREE_TYPE, Sponge.getRegistry().getType(TreeType.class, this.woodType.name()).orElseThrow(NullPointerException::new)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeWoodPlanks readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.woodType = EnumWoodType.getByName(((TreeType)valueContainer.get(Keys.TREE_TYPE).get()).getName()).orElseThrow(NullPointerException::new);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeWoodPlanks that = (SpongeBlockTypeWoodPlanks)o;
        return this.woodType == that.woodType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.woodType});
    }
}

