/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpongeBlockTypeMultipleFacing;
import com.degoos.wetsponge.material.block.type.WSBlockTypeTripwire;
import java.util.Objects;
import java.util.Set;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeTripwire
extends SpongeBlockTypeMultipleFacing
implements WSBlockTypeTripwire {
    private boolean disarmed;
    private boolean attached;
    private boolean powered;

    public SpongeBlockTypeTripwire(Set<EnumBlockFace> faces, Set<EnumBlockFace> allowedFaces, boolean disarmed, boolean attached, boolean powered) {
        super(132, "minecraft:tripwire", "minecraft:tripwire", 64, faces, allowedFaces);
        this.disarmed = disarmed;
        this.attached = attached;
        this.powered = powered;
    }

    @Override
    public boolean isDisarmed() {
        return this.disarmed;
    }

    @Override
    public void setDisarmed(boolean disarmed) {
        this.disarmed = disarmed;
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public void setAttached(boolean attached) {
        this.attached = attached;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public SpongeBlockTypeTripwire clone() {
        return new SpongeBlockTypeTripwire(this.getFaces(), this.getAllowedFaces(), this.disarmed, this.attached, this.powered);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.ATTACHED, (Object)this.attached);
        itemStack.offer(Keys.POWERED, (Object)this.powered);
        itemStack.offer(Keys.DISARMED, (Object)this.disarmed);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        blockState = blockState.with(Keys.ATTACHED, (Object)this.attached).orElse(blockState);
        blockState = blockState.with(Keys.POWERED, (Object)this.powered).orElse(blockState);
        return blockState.with(Keys.DISARMED, (Object)this.disarmed).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeTripwire readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.attached = valueContainer.get(Keys.ATTACHED).orElse(false);
        this.powered = valueContainer.get(Keys.POWERED).orElse(false);
        this.disarmed = valueContainer.get(Keys.DISARMED).orElse(false);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeTripwire that = (SpongeBlockTypeTripwire)o;
        return this.disarmed == that.disarmed && this.attached == that.attached && this.powered == that.powered;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.disarmed, this.attached, this.powered);
    }
}

