/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeBisectedHalf;
import com.degoos.wetsponge.material.block.SpongeBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeTrapDoor;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.PortionTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeTrapDoor
extends SpongeBlockTypeDirectional
implements WSBlockTypeTrapDoor {
    private EnumBlockTypeBisectedHalf half;
    private boolean open;
    private boolean powered;
    private boolean waterlogged;

    public SpongeBlockTypeTrapDoor(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockTypeBisectedHalf half, boolean open, boolean powered, boolean waterlogged) {
        super(numericalId, oldStringId, newStringId, maxStackSize, facing, faces);
        Validate.notNull((Object)half, "Half cannot be null!");
        this.half = half;
        this.open = open;
        this.powered = powered;
        this.waterlogged = waterlogged;
    }

    @Override
    public EnumBlockTypeBisectedHalf getHalf() {
        return this.half;
    }

    @Override
    public void setHalf(EnumBlockTypeBisectedHalf half) {
        Validate.notNull((Object)half, "Half cannot be null!");
        this.half = half;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    @Override
    public void setWaterlogged(boolean waterlogged) {
        this.waterlogged = waterlogged;
    }

    @Override
    public SpongeBlockTypeTrapDoor clone() {
        return new SpongeBlockTypeTrapDoor(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.getFacing(), this.getFaces(), this.half, this.open, this.powered, this.waterlogged);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.OPEN, (Object)this.open);
        itemStack.offer(Keys.PORTION_TYPE, (Object)(this.half == EnumBlockTypeBisectedHalf.TOP ? PortionTypes.TOP : PortionTypes.BOTTOM));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        blockState = blockState.with(Keys.OPEN, (Object)this.open).orElse(blockState);
        return blockState.with(Keys.PORTION_TYPE, (Object)(this.half == EnumBlockTypeBisectedHalf.TOP ? PortionTypes.TOP : PortionTypes.BOTTOM)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeTrapDoor readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.open = valueContainer.get(Keys.OPEN).orElse(false);
        this.half = valueContainer.get(Keys.PORTION_TYPE).orElse(PortionTypes.BOTTOM).equals(PortionTypes.BOTTOM) ? EnumBlockTypeBisectedHalf.BOTTOM : EnumBlockTypeBisectedHalf.TOP;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeTrapDoor that = (SpongeBlockTypeTrapDoor)o;
        return this.open == that.open && this.powered == that.powered && this.waterlogged == that.waterlogged && this.half == that.half;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.half, this.open, this.powered, this.waterlogged});
    }
}

