/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeTallGrassType;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeTallGrass;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.ShrubType;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeTallGrassType
extends SpongeBlockType
implements WSBlockTypeTallGrass {
    private EnumBlockTypeTallGrassType tallGrassType;

    public SpongeBlockTypeTallGrassType(EnumBlockTypeTallGrassType tallGrassType) {
        super(31, "minecraft:tallgrass", "minecraft:grass", 64);
        Validate.notNull((Object)tallGrassType, "Tall grass type cannot be null!");
        this.tallGrassType = tallGrassType;
    }

    @Override
    public String getNewStringId() {
        switch (this.tallGrassType) {
            case FERN: {
                return "minecraft:fern";
            }
            case DEAD_BUSH: {
                return "minecraft:dead_bush";
            }
        }
        return "minecraft:grass";
    }

    @Override
    public EnumBlockTypeTallGrassType getTallGrassType() {
        return this.tallGrassType;
    }

    @Override
    public void setTallGrassType(EnumBlockTypeTallGrassType tallGrassType) {
        Validate.notNull((Object)tallGrassType, "Tall grass type cannot be null!");
        this.tallGrassType = tallGrassType;
    }

    @Override
    public SpongeBlockTypeTallGrassType clone() {
        return new SpongeBlockTypeTallGrassType(this.tallGrassType);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.SHRUB_TYPE, Sponge.getRegistry().getType(ShrubType.class, this.tallGrassType.name()).orElseThrow(NullPointerException::new));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.SHRUB_TYPE, Sponge.getRegistry().getType(ShrubType.class, this.tallGrassType.name()).orElseThrow(NullPointerException::new)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeTallGrassType readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.tallGrassType = EnumBlockTypeTallGrassType.getByName(((ShrubType)valueContainer.get(Keys.SHRUB_TYPE).get()).getName()).orElse(EnumBlockTypeTallGrassType.DEAD_BUSH);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeTallGrassType that = (SpongeBlockTypeTallGrassType)o;
        return this.tallGrassType == that.tallGrassType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.tallGrassType});
    }
}

