/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeStoneBrickType;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeStoneBrick;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.BrickType;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeStoneBrick
extends SpongeBlockType
implements WSBlockTypeStoneBrick {
    private EnumBlockTypeStoneBrickType stoneBrickType;

    public SpongeBlockTypeStoneBrick(EnumBlockTypeStoneBrickType stoneBrickType) {
        super(98, "minecraft:stonebrick", "minecraft:stone_bricks", 64);
        Validate.notNull((Object)stoneBrickType, "Stone brick type cannot be null!");
        this.stoneBrickType = stoneBrickType;
    }

    @Override
    public String getNewStringId() {
        switch (this.stoneBrickType) {
            case MOSSY: {
                return "minecraft:mossy_stone_bricks";
            }
            case CRACKED: {
                return "minecraft:cracked_stone_bricks";
            }
            case CHISELED: {
                return "minecraft:chiseled_stone_bricks";
            }
        }
        return "minecraft:stone_bricks";
    }

    @Override
    public EnumBlockTypeStoneBrickType getStoneBrickType() {
        return this.stoneBrickType;
    }

    @Override
    public void setStoneBrickType(EnumBlockTypeStoneBrickType stoneBrickType) {
        Validate.notNull((Object)stoneBrickType, "Stone brick type cannot be null!");
        this.stoneBrickType = stoneBrickType;
    }

    @Override
    public SpongeBlockTypeStoneBrick clone() {
        return new SpongeBlockTypeStoneBrick(this.stoneBrickType);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.BRICK_TYPE, Sponge.getRegistry().getType(BrickType.class, this.stoneBrickType.name()).orElseThrow(NullPointerException::new));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.BRICK_TYPE, Sponge.getRegistry().getType(BrickType.class, this.stoneBrickType.name()).orElseThrow(NullPointerException::new)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeStoneBrick readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.stoneBrickType = EnumBlockTypeStoneBrickType.getByName(((BrickType)valueContainer.get(Keys.BRICK_TYPE).get()).getName()).orElseThrow(NullPointerException::new);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeStoneBrick that = (SpongeBlockTypeStoneBrick)o;
        return this.stoneBrickType == that.stoneBrickType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.stoneBrickType});
    }
}

