/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeSandType;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSandstoneType;
import com.degoos.wetsponge.material.block.SpongeBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSandstone;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.SandstoneType;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeSandstone
extends SpongeBlockType
implements WSBlockTypeSandstone {
    private EnumBlockTypeSandType sandType;
    private EnumBlockTypeSandstoneType sandstoneType;

    public SpongeBlockTypeSandstone(EnumBlockTypeSandType sandType, EnumBlockTypeSandstoneType sandstoneType) {
        super(24, "minecraft:sandstone", "minecraft:sandstone", 64);
        Validate.notNull((Object)sandType, "Sand type cannot be null!");
        Validate.notNull((Object)sandstoneType, "Sandstone type cannot be null!");
        this.sandType = sandType;
        this.sandstoneType = sandstoneType;
    }

    @Override
    public int getNumericalId() {
        return this.sandType == EnumBlockTypeSandType.NORMAL ? 24 : 179;
    }

    @Override
    public String getOldStringId() {
        return this.sandType == EnumBlockTypeSandType.RED ? "minecraft:red_sandstone" : "minecraft:sandstone";
    }

    @Override
    public String getNewStringId() {
        String prefix = this.sandstoneType == EnumBlockTypeSandstoneType.DEFAULT ? "" : (this.sandstoneType == EnumBlockTypeSandstoneType.SMOOTH ? "cut_" : "chiseled_");
        return prefix + (this.sandType == EnumBlockTypeSandType.RED ? "red_sandstone" : "sandstone");
    }

    @Override
    public EnumBlockTypeSandType getSandType() {
        return this.sandType;
    }

    @Override
    public void setSandType(EnumBlockTypeSandType sandType) {
        Validate.notNull((Object)sandType, "Sand type cannot be null!");
        this.sandType = sandType;
    }

    @Override
    public EnumBlockTypeSandstoneType getSandstoneType() {
        return this.sandstoneType;
    }

    @Override
    public void setSandstoneType(EnumBlockTypeSandstoneType sandstoneType) {
        Validate.notNull((Object)sandstoneType, "Sandstone type cannot be null!");
        this.sandstoneType = sandstoneType;
    }

    @Override
    public SpongeBlockTypeSandstone clone() {
        return new SpongeBlockTypeSandstone(this.sandType, this.sandstoneType);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.SANDSTONE_TYPE, Sponge.getRegistry().getType(SandstoneType.class, this.sandstoneType.name()).orElseThrow(NullPointerException::new));
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.SANDSTONE_TYPE, Sponge.getRegistry().getType(SandstoneType.class, this.sandstoneType.name()).orElseThrow(NullPointerException::new)).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeSandstone readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.sandstoneType = EnumBlockTypeSandstoneType.getByName(((SandstoneType)valueContainer.get(Keys.SANDSTONE_TYPE).get()).getName()).orElse(EnumBlockTypeSandstoneType.DEFAULT);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeSandstone that = (SpongeBlockTypeSandstone)o;
        return this.sandType == that.sandType && this.sandstoneType == that.sandstoneType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.sandType, this.sandstoneType});
    }
}

