/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpongeBlockTypeMultipleFacing;
import com.degoos.wetsponge.material.block.type.WSBlockTypeFire;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.BlockFire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeFire
extends SpongeBlockTypeMultipleFacing
implements WSBlockTypeFire {
    private int age;
    private int maximumAge;

    public SpongeBlockTypeFire(Set<EnumBlockFace> faces, Set<EnumBlockFace> allowedFaces, int age, int maximumAge) {
        super(51, "minecraft:fire", "minecraft:fire", 64, faces, allowedFaces);
        this.age = age;
        this.maximumAge = maximumAge;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int age) {
        this.age = Math.min(this.maximumAge, Math.max(0, age));
    }

    @Override
    public int getMaximumAge() {
        return this.maximumAge;
    }

    @Override
    public SpongeBlockTypeFire clone() {
        return new SpongeBlockTypeFire(this.getFaces(), this.getAllowedFaces(), this.age, this.maximumAge);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        IBlockState iBlockState = (IBlockState)blockState;
        iBlockState = iBlockState.func_177226_a((IProperty)BlockFire.field_176545_N, (Comparable)Boolean.valueOf(this.hasFace(EnumBlockFace.NORTH)));
        iBlockState = iBlockState.func_177226_a((IProperty)BlockFire.field_176541_P, (Comparable)Boolean.valueOf(this.hasFace(EnumBlockFace.SOUTH)));
        iBlockState = iBlockState.func_177226_a((IProperty)BlockFire.field_176546_O, (Comparable)Boolean.valueOf(this.hasFace(EnumBlockFace.EAST)));
        iBlockState = iBlockState.func_177226_a((IProperty)BlockFire.field_176539_Q, (Comparable)Boolean.valueOf(this.hasFace(EnumBlockFace.WEST)));
        iBlockState = iBlockState.func_177226_a((IProperty)BlockFire.field_176542_R, (Comparable)Boolean.valueOf(this.hasFace(EnumBlockFace.UP)));
        iBlockState = iBlockState.func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(this.age));
        return (BlockState)iBlockState;
    }

    @Override
    public SpongeBlockTypeFire readContainer(ValueContainer<?> valueContainer) {
        if (!(valueContainer instanceof IBlockState)) {
            return this;
        }
        IBlockState iBlockState = (IBlockState)valueContainer;
        this.age = (Integer)iBlockState.func_177229_b((IProperty)BlockFire.field_176543_a);
        this.setFace(EnumBlockFace.NORTH, (Boolean)iBlockState.func_177229_b((IProperty)BlockFire.field_176545_N));
        this.setFace(EnumBlockFace.SOUTH, (Boolean)iBlockState.func_177229_b((IProperty)BlockFire.field_176541_P));
        this.setFace(EnumBlockFace.EAST, (Boolean)iBlockState.func_177229_b((IProperty)BlockFire.field_176546_O));
        this.setFace(EnumBlockFace.WEST, (Boolean)iBlockState.func_177229_b((IProperty)BlockFire.field_176539_Q));
        this.setFace(EnumBlockFace.UP, (Boolean)iBlockState.func_177229_b((IProperty)BlockFire.field_176542_R));
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeFire that = (SpongeBlockTypeFire)o;
        return this.age == that.age && this.maximumAge == that.maximumAge;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.age, this.maximumAge);
    }
}

