/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpongeBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeCocoa;
import java.util.Objects;
import java.util.Set;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeBlockTypeCocoa
extends SpongeBlockTypeDirectional
implements WSBlockTypeCocoa {
    private int age;
    private int maximumAge;

    public SpongeBlockTypeCocoa(EnumBlockFace facing, Set<EnumBlockFace> faces, int age, int maximumAge) {
        super(127, "minecraft:cocoa", "minecraft:cocoa", 64, facing, faces);
        this.age = age;
        this.maximumAge = maximumAge;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int age) {
        this.age = Math.min(this.maximumAge, Math.max(0, age));
    }

    @Override
    public int getMaximumAge() {
        return this.maximumAge;
    }

    @Override
    public SpongeBlockTypeCocoa clone() {
        return new SpongeBlockTypeCocoa(this.getFacing(), this.getFaces(), this.age, this.maximumAge);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.GROWTH_STAGE, (Object)this.age);
        return itemStack;
    }

    @Override
    public BlockState writeBlockState(BlockState blockState) {
        blockState = super.writeBlockState(blockState);
        return blockState.with(Keys.GROWTH_STAGE, (Object)this.age).orElse(blockState);
    }

    @Override
    public SpongeBlockTypeCocoa readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.age = valueContainer.get(Keys.GROWTH_STAGE).orElse(0);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockTypeCocoa that = (SpongeBlockTypeCocoa)o;
        return this.age == that.age && this.maximumAge == that.maximumAge;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.age, this.maximumAge);
    }
}

