/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeStructureBlockMode;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeStructureBlock;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeStructureBlock
extends SpigotBlockType
implements WSBlockTypeStructureBlock {
    private EnumBlockTypeStructureBlockMode mode;

    public SpigotBlockTypeStructureBlock(EnumBlockTypeStructureBlockMode mode) {
        super(255, "minecraft:structure_block", "minecraft:structure_block", 64);
        Validate.notNull((Object)mode, "Mode cannot be null!");
        this.mode = mode;
    }

    @Override
    public EnumBlockTypeStructureBlockMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(EnumBlockTypeStructureBlockMode mode) {
        Validate.notNull((Object)mode, "Mode cannot be null!");
        this.mode = mode;
    }

    @Override
    public SpigotBlockTypeStructureBlock clone() {
        return new SpigotBlockTypeStructureBlock(this.mode);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData((byte)this.mode.getValue());
        return data;
    }

    @Override
    public SpigotBlockTypeStructureBlock readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        this.mode = EnumBlockTypeStructureBlockMode.getByValue(materialData.getData()).orElse(EnumBlockTypeStructureBlockMode.DATA);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeStructureBlock that = (SpigotBlockTypeStructureBlock)o;
        return this.mode == that.mode;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mode});
    }
}

