/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeStoneBrickType;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeStoneBrick;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeStoneBrick
extends SpigotBlockType
implements WSBlockTypeStoneBrick {
    private EnumBlockTypeStoneBrickType stoneBrickType;

    public SpigotBlockTypeStoneBrick(EnumBlockTypeStoneBrickType stoneBrickType) {
        super(98, "minecraft:stonebrick", "minecraft:stone_bricks", 64);
        Validate.notNull((Object)stoneBrickType, "Stone brick type cannot be null!");
        this.stoneBrickType = stoneBrickType;
    }

    @Override
    public String getNewStringId() {
        switch (this.stoneBrickType) {
            case MOSSY: {
                return "minecraft:mossy_stone_bricks";
            }
            case CRACKED: {
                return "minecraft:cracked_stone_bricks";
            }
            case CHISELED: {
                return "minecraft:chiseled_stone_bricks";
            }
        }
        return "minecraft:stone_bricks";
    }

    @Override
    public EnumBlockTypeStoneBrickType getStoneBrickType() {
        return this.stoneBrickType;
    }

    @Override
    public void setStoneBrickType(EnumBlockTypeStoneBrickType stoneBrickType) {
        Validate.notNull((Object)stoneBrickType, "Stone brick type cannot be null!");
        this.stoneBrickType = stoneBrickType;
    }

    @Override
    public SpigotBlockTypeStoneBrick clone() {
        return new SpigotBlockTypeStoneBrick(this.stoneBrickType);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData((byte)this.stoneBrickType.getValue());
        return data;
    }

    @Override
    public SpigotBlockTypeStoneBrick readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        this.stoneBrickType = EnumBlockTypeStoneBrickType.getByValue(materialData.getData()).orElse(EnumBlockTypeStoneBrickType.DEFAULT);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeStoneBrick that = (SpigotBlockTypeStoneBrick)o;
        return this.stoneBrickType == that.stoneBrickType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.stoneBrickType});
    }
}

