/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeSlabPosition;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSlabType;
import com.degoos.wetsponge.material.block.SpigotBlockTypeWaterlogged;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSlab;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeSlab
extends SpigotBlockTypeWaterlogged
implements WSBlockTypeSlab {
    private EnumBlockTypeSlabType type;
    private EnumBlockTypeSlabPosition position;

    public SpigotBlockTypeSlab(boolean waterLogged, EnumBlockTypeSlabType type, EnumBlockTypeSlabPosition position) {
        super(43, "minecraft:double_stone_slab", "minecraft:stone_slab", 64, waterLogged);
        Validate.notNull((Object)type, "Type cannot be null!");
        Validate.notNull((Object)position, "Position cannot be null!");
        this.type = type;
        this.position = position;
    }

    @Override
    public int getNumericalId() {
        switch (this.type) {
            case OAK: 
            case SPRUCE: 
            case BIRCH: 
            case JUNGLE: 
            case ACACIA: 
            case DARK_OAK: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? 125 : 126;
            }
            case STONE: 
            case RED_SANDSTONE: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? 181 : 182;
            }
            case PURPUR: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? 204 : 205;
            }
        }
        return this.position == EnumBlockTypeSlabPosition.DOUBLE ? 43 : 44;
    }

    @Override
    public String getOldStringId() {
        switch (this.type) {
            case OAK: 
            case SPRUCE: 
            case BIRCH: 
            case JUNGLE: 
            case ACACIA: 
            case DARK_OAK: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? "minecraft:double_wooden_slab" : "minecraft:wooden_slab";
            }
            case STONE: 
            case RED_SANDSTONE: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? "minecraft:double_stone_slab" : "minecraft:stone_slab";
            }
            case PURPUR: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? "minecraft:double_purpur_slab" : "minecraft:purpur_slab";
            }
        }
        return this.position == EnumBlockTypeSlabPosition.DOUBLE ? "minecraft:double_stone_slab2" : "minecraft:stone_slab2";
    }

    @Override
    public String getNewStringId() {
        return this.type.name().toLowerCase() + "_slab";
    }

    @Override
    public EnumBlockTypeSlabType getType() {
        return this.type;
    }

    @Override
    public void setType(EnumBlockTypeSlabType type) {
        Validate.notNull((Object)type, "Type cannot be null!");
        this.type = type;
    }

    @Override
    public EnumBlockTypeSlabPosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(EnumBlockTypeSlabPosition position) {
        Validate.notNull((Object)position, "Position cannot be null!");
        this.position = position;
    }

    @Override
    public SpigotBlockTypeSlab clone() {
        return new SpigotBlockTypeSlab(this.isWaterlogged(), this.type, this.position);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData(this.getDataValue());
        return data;
    }

    private byte getDataValue() {
        switch (this.type) {
            case RED_SANDSTONE: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 8 : 0);
            }
            case PURPUR: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 8 : 0);
            }
            case OAK: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 8 : 0);
            }
            case SPRUCE: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 9 : 1);
            }
            case BIRCH: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 10 : 2);
            }
            case JUNGLE: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 11 : 3);
            }
            case ACACIA: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 12 : 4);
            }
            case DARK_OAK: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 13 : 5);
            }
            case STONE: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 8 : 0);
            }
            case SANDSTONE: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 9 : 1);
            }
            case PETRIFIED_OAK: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 10 : 2);
            }
            case COBBLESTONE: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 11 : 3);
            }
            case BRICK: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 12 : 4);
            }
            case STONE_BRICK: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 13 : 5);
            }
            case NETHER_BRICK: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 14 : 6);
            }
            case QUARTZ: {
                return (byte)(this.position == EnumBlockTypeSlabPosition.TOP ? 15 : 7);
            }
        }
        return 0;
    }

    @Override
    public SpigotBlockTypeSlab readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        int data = materialData.getData();
        int id = this.getNumericalId();
        int newData = data > 7 ? data - 8 : data;
        block0 : switch (id) {
            case 43: 
            case 44: {
                switch (newData) {
                    case 1: {
                        this.type = EnumBlockTypeSlabType.SANDSTONE;
                        break block0;
                    }
                    case 2: {
                        this.type = EnumBlockTypeSlabType.PETRIFIED_OAK;
                        break block0;
                    }
                    case 3: {
                        this.type = EnumBlockTypeSlabType.COBBLESTONE;
                        break block0;
                    }
                    case 5: {
                        this.type = EnumBlockTypeSlabType.BRICK;
                        break block0;
                    }
                    case 6: {
                        this.type = EnumBlockTypeSlabType.STONE_BRICK;
                        break block0;
                    }
                    case 7: {
                        this.type = EnumBlockTypeSlabType.QUARTZ;
                        break block0;
                    }
                }
                this.type = EnumBlockTypeSlabType.STONE;
                break;
            }
            case 125: 
            case 126: {
                switch (newData) {
                    case 1: {
                        this.type = EnumBlockTypeSlabType.SPRUCE;
                        break block0;
                    }
                    case 2: {
                        this.type = EnumBlockTypeSlabType.BIRCH;
                        break block0;
                    }
                    case 3: {
                        this.type = EnumBlockTypeSlabType.JUNGLE;
                        break block0;
                    }
                    case 4: {
                        this.type = EnumBlockTypeSlabType.ACACIA;
                        break block0;
                    }
                    case 5: {
                        this.type = EnumBlockTypeSlabType.DARK_OAK;
                        break block0;
                    }
                }
                this.type = EnumBlockTypeSlabType.OAK;
                break;
            }
            default: {
                this.type = EnumBlockTypeSlabType.STONE;
            }
        }
        this.position = id == 43 || id == 125 || id == 181 || id == 204 ? EnumBlockTypeSlabPosition.DOUBLE : (data > 7 ? EnumBlockTypeSlabPosition.TOP : EnumBlockTypeSlabPosition.BOTTOM);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeSlab that = (SpigotBlockTypeSlab)o;
        return this.type == that.type && this.position == that.position;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type, this.position});
    }
}

