/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSkullType;
import com.degoos.wetsponge.material.block.SpigotBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSkull;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeSkull
extends SpigotBlockTypeDirectional
implements WSBlockTypeSkull {
    private EnumBlockFace rotation;
    private EnumBlockTypeSkullType skullType;

    public SpigotBlockTypeSkull(EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockFace rotation, EnumBlockTypeSkullType skullType) {
        super(144, "minecraft:skull", "minecraft:skull", 64, facing, faces);
        Validate.notNull((Object)rotation, "Rotation cannot be null!");
        Validate.notNull((Object)skullType, "Skull type cannot be null!");
        this.rotation = rotation;
        this.skullType = skullType;
    }

    @Override
    public String getNewStringId() {
        return "minecraft:" + this.skullType.getMinecraftName() + (this.getFacing() != EnumBlockFace.DOWN ? "_wall" : "") + "_head";
    }

    @Override
    public EnumBlockTypeSkullType getSkullType() {
        return this.skullType;
    }

    @Override
    public void setSkullType(EnumBlockTypeSkullType skullType) {
        Validate.notNull((Object)skullType, "Skull type cannot be null!");
        this.skullType = skullType;
    }

    @Override
    public EnumBlockFace getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(EnumBlockFace rotation) {
        Validate.notNull((Object)rotation, "Rotation cannot be null!");
        this.rotation = rotation;
    }

    @Override
    public Set<EnumBlockFace> getFaces() {
        Set<EnumBlockFace> faces = super.getFaces();
        faces.add(EnumBlockFace.UP);
        return faces;
    }

    @Override
    public SpigotBlockTypeSkull clone() {
        return new SpigotBlockTypeSkull(this.getFacing(), this.getFaces(), this.rotation, this.skullType);
    }

    @Override
    public MaterialData toMaterialData() {
        return super.toMaterialData();
    }

    @Override
    public SpigotBlockTypeSkull readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeSkull that = (SpigotBlockTypeSkull)o;
        return this.rotation == that.rotation && this.skullType == that.skullType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.rotation, this.skullType});
    }
}

