/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeSandType;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSandstoneType;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSandstone;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeSandstone
extends SpigotBlockType
implements WSBlockTypeSandstone {
    private EnumBlockTypeSandType sandType;
    private EnumBlockTypeSandstoneType sandstoneType;

    public SpigotBlockTypeSandstone(EnumBlockTypeSandType sandType, EnumBlockTypeSandstoneType sandstoneType) {
        super(24, "minecraft:sandstone", "minecraft:sandstone", 64);
        Validate.notNull((Object)sandType, "Sand type cannot be null!");
        Validate.notNull((Object)sandstoneType, "Sandstone type cannot be null!");
        this.sandType = sandType;
        this.sandstoneType = sandstoneType;
    }

    @Override
    public int getNumericalId() {
        return this.sandType == EnumBlockTypeSandType.NORMAL ? 24 : 179;
    }

    @Override
    public String getOldStringId() {
        return this.sandType == EnumBlockTypeSandType.RED ? "minecraft:red_sandstone" : "minecraft:sandstone";
    }

    @Override
    public String getNewStringId() {
        String prefix = this.sandstoneType == EnumBlockTypeSandstoneType.DEFAULT ? "" : (this.sandstoneType == EnumBlockTypeSandstoneType.SMOOTH ? "cut_" : "chiseled_");
        return prefix + (this.sandType == EnumBlockTypeSandType.RED ? "red_sandstone" : "sandstone");
    }

    @Override
    public EnumBlockTypeSandType getSandType() {
        return this.sandType;
    }

    @Override
    public void setSandType(EnumBlockTypeSandType sandType) {
        Validate.notNull((Object)sandType, "Sand type cannot be null!");
        this.sandType = sandType;
    }

    @Override
    public EnumBlockTypeSandstoneType getSandstoneType() {
        return this.sandstoneType;
    }

    @Override
    public void setSandstoneType(EnumBlockTypeSandstoneType sandstoneType) {
        Validate.notNull((Object)sandstoneType, "Sandstone type cannot be null!");
        this.sandstoneType = sandstoneType;
    }

    @Override
    public SpigotBlockTypeSandstone clone() {
        return new SpigotBlockTypeSandstone(this.sandType, this.sandstoneType);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData((byte)this.sandstoneType.getValue());
        return data;
    }

    @Override
    public SpigotBlockTypeSandstone readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        this.sandstoneType = EnumBlockTypeSandstoneType.getByValue(materialData.getData()).orElse(EnumBlockTypeSandstoneType.DEFAULT);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeSandstone that = (SpigotBlockTypeSandstone)o;
        return this.sandType == that.sandType && this.sandstoneType == that.sandstoneType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.sandType, this.sandstoneType});
    }
}

