/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpigotBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeRepeater;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.Diode;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeRepeater
extends SpigotBlockTypeDirectional
implements WSBlockTypeRepeater {
    private int delay;
    private int minimumDelay;
    private int maximumDelay;
    private boolean locked;
    private boolean powered;

    public SpigotBlockTypeRepeater(EnumBlockFace facing, Set<EnumBlockFace> faces, int delay, int minimumDelay, int maximumDelay, boolean locked, boolean powered) {
        super(93, "minecraft:unpowered_repeater", "minecraft:repeater", 64, facing, faces);
        this.delay = delay;
        this.minimumDelay = minimumDelay;
        this.maximumDelay = maximumDelay;
        this.locked = locked;
        this.powered = powered;
    }

    @Override
    public int getNumericalId() {
        return this.powered ? 94 : 93;
    }

    @Override
    public String getOldStringId() {
        return this.powered ? "minecraft:powered_repeater" : "minecraft:unpowered_repeater";
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public void setDelay(int delay) {
        this.delay = Math.max(this.minimumDelay, Math.min(this.minimumDelay, delay));
    }

    @Override
    public int getMinimumDelay() {
        return this.minimumDelay;
    }

    @Override
    public int getMaximumDelay() {
        return this.maximumDelay;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public SpigotBlockTypeRepeater clone() {
        return new SpigotBlockTypeRepeater(this.getFacing(), this.getFaces(), this.delay, this.minimumDelay, this.maximumDelay, this.locked, this.powered);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        if (data instanceof Diode) {
            ((Diode)data).setDelay(this.delay);
        }
        return data;
    }

    @Override
    public SpigotBlockTypeRepeater readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        if (materialData instanceof Diode) {
            this.delay = ((Diode)materialData).getDelay();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeRepeater that = (SpigotBlockTypeRepeater)o;
        return this.delay == that.delay && this.minimumDelay == that.minimumDelay && this.maximumDelay == that.maximumDelay && this.locked == that.locked && this.powered == that.powered;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delay, this.minimumDelay, this.maximumDelay, this.locked, this.powered);
    }
}

