/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeRedstoneWireConnection;
import com.degoos.wetsponge.material.block.SpigotBlockTypeAnaloguePowerable;
import com.degoos.wetsponge.material.block.type.WSBlockTypeRedstoneWire;
import com.degoos.wetsponge.util.Validate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeRedstoneWire
extends SpigotBlockTypeAnaloguePowerable
implements WSBlockTypeRedstoneWire {
    private Map<EnumBlockFace, EnumBlockTypeRedstoneWireConnection> connections;
    private Set<EnumBlockFace> allowedFaces;

    public SpigotBlockTypeRedstoneWire(int power, int maximumPower, Map<EnumBlockFace, EnumBlockTypeRedstoneWireConnection> connections, Set<EnumBlockFace> allowedFaces) {
        super(55, "minecraft:redstone_wire", "minecraft:redstone_wire", 64, power, maximumPower);
        this.connections = connections == null ? new HashMap() : connections;
        this.allowedFaces = allowedFaces == null ? new HashSet() : allowedFaces;
    }

    @Override
    public EnumBlockTypeRedstoneWireConnection getFaceConnection(EnumBlockFace face) {
        Validate.notNull((Object)face, "Face cannot be null!");
        return this.connections.getOrDefault((Object)face, EnumBlockTypeRedstoneWireConnection.NONE);
    }

    @Override
    public void setFaceConnection(EnumBlockFace face, EnumBlockTypeRedstoneWireConnection connection) {
        Validate.notNull((Object)face, "Face cannot be null!");
        this.connections.put(face, connection == null ? EnumBlockTypeRedstoneWireConnection.NONE : connection);
    }

    @Override
    public Set<EnumBlockFace> getAllowedFaces() {
        return this.allowedFaces;
    }

    @Override
    public SpigotBlockTypeRedstoneWire clone() {
        return new SpigotBlockTypeRedstoneWire(this.getPower(), this.gerMaximumPower(), this.connections, this.allowedFaces);
    }

    @Override
    public MaterialData toMaterialData() {
        return super.toMaterialData();
    }

    @Override
    public SpigotBlockTypeRedstoneWire readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeRedstoneWire that = (SpigotBlockTypeRedstoneWire)o;
        return Objects.equals(this.connections, that.connections) && Objects.equals(this.allowedFaces, that.allowedFaces);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.connections, this.allowedFaces);
    }
}

