/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumWoodType;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeLeaves;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeLeaves
extends SpigotBlockType
implements WSBlockTypeLeaves {
    private boolean persistent;
    private int distance;
    private EnumWoodType woodType;

    public SpigotBlockTypeLeaves(boolean persistent, int distance, EnumWoodType woodType) {
        super(18, "minecraft_leaves", "minecraft:leaves", 64);
        Validate.notNull((Object)woodType, "Wood type cannot be null!");
        this.persistent = persistent;
        this.distance = Math.min(7, Math.max(1, distance));
        this.woodType = woodType;
    }

    @Override
    public int getNumericalId() {
        return this.getWoodType() == EnumWoodType.ACACIA || this.getWoodType() == EnumWoodType.DARK_OAK ? 161 : 18;
    }

    @Override
    public String getNewStringId() {
        return this.getWoodType() == EnumWoodType.ACACIA || this.getWoodType() == EnumWoodType.DARK_OAK ? "minecraft:leaves2" : "minecraft:leaves";
    }

    @Override
    public String getOldStringId() {
        return "minecraft:" + this.getWoodType().name().toLowerCase() + "_leaves";
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public int getDistance() {
        return this.distance;
    }

    @Override
    public void setDistance(int distance) {
        this.distance = Math.min(7, Math.max(1, distance));
    }

    @Override
    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public void setWoodType(EnumWoodType woodType) {
        Validate.notNull((Object)woodType, "Wood type cannot be null!");
        this.woodType = woodType;
    }

    @Override
    public SpigotBlockTypeLeaves clone() {
        return new SpigotBlockTypeLeaves(this.persistent, this.distance, this.woodType);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData((byte)(this.woodType.getValue() % 4 + (this.persistent ? 4 : 0)));
        return data;
    }

    @Override
    public SpigotBlockTypeLeaves readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        byte data = materialData.getData();
        this.woodType = materialData.getItemType().getId() == 161 ? (data % 4 == 0 ? EnumWoodType.ACACIA : EnumWoodType.DARK_OAK) : EnumWoodType.getByValue(data % 4).orElse(EnumWoodType.OAK);
        this.persistent = data > 3;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeLeaves that = (SpigotBlockTypeLeaves)o;
        return this.persistent == that.persistent && this.distance == that.distance && this.woodType == that.woodType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.persistent, this.distance, this.woodType});
    }
}

