/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeDirtType;
import com.degoos.wetsponge.material.block.SpigotBlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeDirt;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeDirt
extends SpigotBlockType
implements WSBlockTypeDirt {
    private EnumBlockTypeDirtType dirtType;

    public SpigotBlockTypeDirt(EnumBlockTypeDirtType dirtType) {
        super(3, "minecraft:dirt", "minecraft:dirt", 64);
        Validate.notNull((Object)dirtType, "Dirt type cannot be null!");
        this.dirtType = dirtType;
    }

    @Override
    public String getNewStringId() {
        switch (this.dirtType) {
            case PODZOL: {
                return "minecraft:podzol";
            }
            case COARSE_DIRT: {
                return "minecraft:coarse_dirt";
            }
        }
        return "minecraft:dirt";
    }

    @Override
    public EnumBlockTypeDirtType getDirtType() {
        return this.dirtType;
    }

    @Override
    public void setDirtType(EnumBlockTypeDirtType dirtType) {
        Validate.notNull((Object)dirtType, "Dirt type cannot be null!");
        this.dirtType = dirtType;
    }

    @Override
    public SpigotBlockTypeDirt clone() {
        return new SpigotBlockTypeDirt(this.dirtType);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        data.setData((byte)this.dirtType.getValue());
        return data;
    }

    @Override
    public SpigotBlockTypeDirt readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        this.dirtType = EnumBlockTypeDirtType.getByValue(materialData.getData()).orElse(EnumBlockTypeDirtType.DIRT);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeDirt that = (SpigotBlockTypeDirt)o;
        return this.dirtType == that.dirtType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.dirtType});
    }
}

