/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.SpigotBlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeCocoa;
import java.util.Objects;
import java.util.Set;
import org.bukkit.material.CocoaPlant;
import org.bukkit.material.MaterialData;

public class SpigotBlockTypeCocoa
extends SpigotBlockTypeDirectional
implements WSBlockTypeCocoa {
    private int age;
    private int maximumAge;

    public SpigotBlockTypeCocoa(EnumBlockFace facing, Set<EnumBlockFace> faces, int age, int maximumAge) {
        super(127, "minecraft:cocoa", "minecraft:cocoa", 64, facing, faces);
        this.age = age;
        this.maximumAge = maximumAge;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int age) {
        this.age = Math.min(this.maximumAge, Math.max(0, age));
    }

    @Override
    public int getMaximumAge() {
        return this.maximumAge;
    }

    @Override
    public SpigotBlockTypeCocoa clone() {
        return new SpigotBlockTypeCocoa(this.getFacing(), this.getFaces(), this.age, this.maximumAge);
    }

    @Override
    public MaterialData toMaterialData() {
        MaterialData data = super.toMaterialData();
        if (data instanceof CocoaPlant) {
            ((CocoaPlant)data).setSize(this.age == 0 ? CocoaPlant.CocoaPlantSize.SMALL : (this.age == 1 ? CocoaPlant.CocoaPlantSize.MEDIUM : CocoaPlant.CocoaPlantSize.LARGE));
        }
        return data;
    }

    @Override
    public SpigotBlockTypeCocoa readMaterialData(MaterialData materialData) {
        super.readMaterialData(materialData);
        if (materialData instanceof CocoaPlant) {
            switch (((CocoaPlant)materialData).getSize()) {
                case LARGE: {
                    this.age = 2;
                    break;
                }
                case MEDIUM: {
                    this.age = 1;
                    break;
                }
                default: {
                    this.age = 0;
                }
            }
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpigotBlockTypeCocoa that = (SpigotBlockTypeCocoa)o;
        return this.age == that.age && this.maximumAge == that.maximumAge;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.age, this.maximumAge);
    }
}

