/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumWoodType;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeWoodPlanks;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.block.data.BlockData;

public class Spigot13BlockTypeWoodPlanks
extends Spigot13BlockType
implements WSBlockTypeWoodPlanks {
    private EnumWoodType woodType;

    public Spigot13BlockTypeWoodPlanks(EnumWoodType woodType) {
        super(5, "minecraft:planks", "minecraft:planks", 64);
        Validate.notNull((Object)woodType, "Wood type cannot be null!");
        this.woodType = woodType;
    }

    @Override
    public String getNewStringId() {
        switch (this.getWoodType()) {
            case SPRUCE: {
                return "minecraft:spruce_planks";
            }
            case BIRCH: {
                return "minecraft:birch_planks";
            }
            case JUNGLE: {
                return "minecraft:jungle_planks";
            }
            case ACACIA: {
                return "minecraft:acacia_planks";
            }
            case DARK_OAK: {
                return "minecraft:dark_oak_planks";
            }
        }
        return "minecraft:oak_planks";
    }

    @Override
    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public void setWoodType(EnumWoodType woodType) {
        Validate.notNull((Object)woodType, "Wood type cannot be null");
        this.woodType = woodType;
    }

    @Override
    public Spigot13BlockTypeWoodPlanks clone() {
        return new Spigot13BlockTypeWoodPlanks(this.woodType);
    }

    @Override
    public Spigot13BlockTypeWoodPlanks readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeWoodPlanks that = (Spigot13BlockTypeWoodPlanks)o;
        return this.woodType == that.woodType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.woodType});
    }
}

