/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSwitchFace;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSwitch;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Switch;

public class Spigot13BlockTypeSwitch
extends Spigot13BlockTypeDirectional
implements WSBlockTypeSwitch {
    private EnumBlockTypeSwitchFace switchFace;
    private boolean powered;

    public Spigot13BlockTypeSwitch(int numericalId, String oldStringId, String newStringId, int maxStackSize, EnumBlockFace facing, Set<EnumBlockFace> faces, EnumBlockTypeSwitchFace switchFace, boolean powered) {
        super(numericalId, oldStringId, newStringId, maxStackSize, facing, faces);
        Validate.notNull((Object)switchFace, "Switch face cannot be null!");
        this.switchFace = switchFace;
        this.powered = powered;
    }

    @Override
    public EnumBlockTypeSwitchFace getSwitchFace() {
        return this.switchFace;
    }

    @Override
    public void setSwitchFace(EnumBlockTypeSwitchFace face) {
        Validate.notNull((Object)face, "Switch face cannot be null!");
        this.switchFace = face;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public Spigot13BlockTypeSwitch clone() {
        return new Spigot13BlockTypeSwitch(this.getNumericalId(), this.getOldStringId(), this.getNewStringId(), this.getMaxStackSize(), this.getFacing(), this.getFaces(), this.switchFace, this.powered);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Switch) {
            ((Switch)blockData).setFace(Switch.Face.valueOf((String)this.switchFace.name()));
            ((Switch)blockData).setPowered(this.powered);
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeSwitch readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Switch) {
            this.switchFace = EnumBlockTypeSwitchFace.valueOf(((Switch)blockData).getFacing().name());
            this.powered = ((Switch)blockData).isPowered();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeSwitch that = (Spigot13BlockTypeSwitch)o;
        return this.powered == that.powered && this.switchFace == that.switchFace;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.switchFace, this.powered});
    }
}

