/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeSlabPosition;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSlabType;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeWaterlogged;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSlab;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;

public class Spigot13BlockTypeSlab
extends Spigot13BlockTypeWaterlogged
implements WSBlockTypeSlab {
    private EnumBlockTypeSlabType type;
    private EnumBlockTypeSlabPosition position;

    public Spigot13BlockTypeSlab(boolean waterLogged, EnumBlockTypeSlabType type, EnumBlockTypeSlabPosition position) {
        super(43, "minecraft:double_stone_slab", "minecraft:stone_slab", 64, waterLogged);
        Validate.notNull((Object)type, "Type cannot be null!");
        Validate.notNull((Object)position, "Position cannot be null!");
        this.type = type;
        this.position = position;
    }

    @Override
    public int getNumericalId() {
        switch (this.type) {
            case OAK: 
            case SPRUCE: 
            case BIRCH: 
            case JUNGLE: 
            case ACACIA: 
            case DARK_OAK: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? 125 : 126;
            }
            case STONE: 
            case RED_SANDSTONE: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? 181 : 182;
            }
            case PURPUR: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? 204 : 205;
            }
        }
        return this.position == EnumBlockTypeSlabPosition.DOUBLE ? 43 : 44;
    }

    @Override
    public String getOldStringId() {
        switch (this.type) {
            case OAK: 
            case SPRUCE: 
            case BIRCH: 
            case JUNGLE: 
            case ACACIA: 
            case DARK_OAK: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? "minecraft:double_wooden_slab" : "minecraft:wooden_slab";
            }
            case STONE: 
            case RED_SANDSTONE: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? "minecraft:double_stone_slab" : "minecraft:stone_slab";
            }
            case PURPUR: {
                return this.position == EnumBlockTypeSlabPosition.DOUBLE ? "minecraft:double_purpur_slab" : "minecraft:purpur_slab";
            }
        }
        return this.position == EnumBlockTypeSlabPosition.DOUBLE ? "minecraft:double_stone_slab2" : "minecraft:stone_slab2";
    }

    @Override
    public String getNewStringId() {
        return this.type.name().toLowerCase() + "_slab";
    }

    @Override
    public EnumBlockTypeSlabType getType() {
        return this.type;
    }

    @Override
    public void setType(EnumBlockTypeSlabType type) {
        Validate.notNull((Object)type, "Type cannot be null!");
        this.type = type;
    }

    @Override
    public EnumBlockTypeSlabPosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(EnumBlockTypeSlabPosition position) {
        Validate.notNull((Object)position, "Position cannot be null!");
        this.position = position;
    }

    @Override
    public Spigot13BlockTypeSlab clone() {
        return new Spigot13BlockTypeSlab(this.isWaterlogged(), this.type, this.position);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Slab) {
            ((Slab)blockData).setType(Slab.Type.valueOf((String)this.position.name()));
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeSlab readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Slab) {
            this.position = EnumBlockTypeSlabPosition.valueOf(((Slab)blockData).getType().name());
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeSlab that = (Spigot13BlockTypeSlab)o;
        return this.type == that.type && this.position == that.position;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type, this.position});
    }
}

