/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.material.block.Spigot13BlockTypeWaterlogged;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSeaPickle;
import java.util.Objects;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.SeaPickle;

public class Spigot13BlockTypeSeaPickle
extends Spigot13BlockTypeWaterlogged
implements WSBlockTypeSeaPickle {
    private int pickles;
    private int minimumPickles;
    private int maximumPickles;

    public Spigot13BlockTypeSeaPickle(boolean waterLogged, int pickles, int minimumPickles, int maximumPickles) {
        super(-1, null, "minecraft:sea_pickle", 64, waterLogged);
        this.pickles = pickles;
        this.minimumPickles = minimumPickles;
        this.maximumPickles = maximumPickles;
    }

    @Override
    public int getPickles() {
        return this.pickles;
    }

    @Override
    public void setPickles(int pickles) {
        this.pickles = Math.min(this.maximumPickles, Math.max(this.minimumPickles, pickles));
    }

    @Override
    public int getMinimumPickles() {
        return this.minimumPickles;
    }

    @Override
    public int getMaximumPickles() {
        return this.maximumPickles;
    }

    @Override
    public Spigot13BlockTypeSeaPickle clone() {
        return new Spigot13BlockTypeSeaPickle(this.isWaterlogged(), this.pickles, this.minimumPickles, this.maximumPickles);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof SeaPickle) {
            ((SeaPickle)blockData).setPickles(this.pickles);
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeSeaPickle readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof SeaPickle) {
            this.pickles = ((SeaPickle)blockData).getPickles();
            this.minimumPickles = ((SeaPickle)blockData).getMinimumPickles();
            this.maximumPickles = ((SeaPickle)blockData).getMaximumPickles();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeSeaPickle that = (Spigot13BlockTypeSeaPickle)o;
        return this.pickles == that.pickles && this.minimumPickles == that.minimumPickles && this.maximumPickles == that.maximumPickles;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pickles, this.minimumPickles, this.maximumPickles);
    }
}

