/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumWoodType;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSapling;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Sapling;

public class Spigot13BlockTypeSapling
extends Spigot13BlockType
implements WSBlockTypeSapling {
    private EnumWoodType woodType;
    private int stage;
    private int maximumStage;

    public Spigot13BlockTypeSapling(EnumWoodType woodType, int stage, int maximumStage) {
        super(6, "minecraft:sapling", "minecraft:sapling", 64);
        Validate.notNull((Object)woodType, "Wood type cannot be null!");
        this.woodType = woodType;
        this.stage = stage;
        this.maximumStage = maximumStage;
    }

    @Override
    public String getNewStringId() {
        switch (this.getWoodType()) {
            case SPRUCE: {
                return "minecraft:spruce_sapling";
            }
            case BIRCH: {
                return "minecraft:birch_sapling";
            }
            case JUNGLE: {
                return "minecraft:jungle_sapling";
            }
            case ACACIA: {
                return "minecraft:acacia_sapling";
            }
            case DARK_OAK: {
                return "minecraft:dark_oak_sapling";
            }
        }
        return "minecraft:oak_sapling";
    }

    @Override
    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public void setWoodType(EnumWoodType woodType) {
        Validate.notNull((Object)woodType, "Wood type cannot be null!");
        this.woodType = woodType;
    }

    @Override
    public int getStage() {
        return this.stage;
    }

    @Override
    public void setStage(int stage) {
        this.stage = Math.min(this.maximumStage, Math.max(0, stage));
    }

    @Override
    public int getMaximumStage() {
        return this.maximumStage;
    }

    @Override
    public Spigot13BlockTypeSapling clone() {
        return new Spigot13BlockTypeSapling(this.woodType, this.stage, this.maximumStage);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Sapling) {
            ((Sapling)blockData).setStage(this.stage);
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeSapling readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Sapling) {
            this.stage = ((Sapling)blockData).getStage();
            this.maximumStage = ((Sapling)blockData).getMaximumStage();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeSapling that = (Spigot13BlockTypeSapling)o;
        return this.stage == that.stage && this.maximumStage == that.maximumStage && this.woodType == that.woodType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.woodType, this.stage, this.maximumStage});
    }
}

