/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockTypeSandType;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSandstoneType;
import com.degoos.wetsponge.material.block.Spigot13BlockType;
import com.degoos.wetsponge.material.block.type.WSBlockTypeSandstone;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.block.data.BlockData;

public class Spigot13BlockTypeSandstone
extends Spigot13BlockType
implements WSBlockTypeSandstone {
    private EnumBlockTypeSandType sandType;
    private EnumBlockTypeSandstoneType sandstoneType;

    public Spigot13BlockTypeSandstone(EnumBlockTypeSandType sandType, EnumBlockTypeSandstoneType sandstoneType) {
        super(24, "minecraft:sandstone", "minecraft:sandstone", 64);
        Validate.notNull((Object)sandType, "Sand type cannot be null!");
        Validate.notNull((Object)sandstoneType, "Sandstone type cannot be null!");
        this.sandType = sandType;
        this.sandstoneType = sandstoneType;
    }

    @Override
    public int getNumericalId() {
        return this.sandType == EnumBlockTypeSandType.NORMAL ? 24 : 179;
    }

    @Override
    public String getOldStringId() {
        return this.sandType == EnumBlockTypeSandType.RED ? "minecraft:red_sandstone" : "minecraft:sandstone";
    }

    @Override
    public String getNewStringId() {
        String prefix = this.sandstoneType == EnumBlockTypeSandstoneType.DEFAULT ? "" : (this.sandstoneType == EnumBlockTypeSandstoneType.SMOOTH ? "cut_" : "chiseled_");
        return prefix + (this.sandType == EnumBlockTypeSandType.RED ? "red_sandstone" : "sandstone");
    }

    @Override
    public EnumBlockTypeSandType getSandType() {
        return this.sandType;
    }

    @Override
    public void setSandType(EnumBlockTypeSandType sandType) {
        Validate.notNull((Object)sandType, "Sand type cannot be null!");
        this.sandType = sandType;
    }

    @Override
    public EnumBlockTypeSandstoneType getSandstoneType() {
        return this.sandstoneType;
    }

    @Override
    public void setSandstoneType(EnumBlockTypeSandstoneType sandstoneType) {
        Validate.notNull((Object)sandstoneType, "Sandstone type cannot be null!");
        this.sandstoneType = sandstoneType;
    }

    @Override
    public Spigot13BlockTypeSandstone clone() {
        return new Spigot13BlockTypeSandstone(this.sandType, this.sandstoneType);
    }

    @Override
    public Spigot13BlockTypeSandstone readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeSandstone that = (Spigot13BlockTypeSandstone)o;
        return this.sandType == that.sandType && this.sandstoneType == that.sandstoneType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.sandType, this.sandstoneType});
    }
}

