/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeDirectional;
import com.degoos.wetsponge.material.block.type.WSBlockTypeRepeater;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Repeater;

public class Spigot13BlockTypeRepeater
extends Spigot13BlockTypeDirectional
implements WSBlockTypeRepeater {
    private int delay;
    private int minimumDelay;
    private int maximumDelay;
    private boolean locked;
    private boolean powered;

    public Spigot13BlockTypeRepeater(EnumBlockFace facing, Set<EnumBlockFace> faces, int delay, int minimumDelay, int maximumDelay, boolean locked, boolean powered) {
        super(93, "minecraft:unpowered_repeater", "minecraft:repeater", 64, facing, faces);
        this.delay = delay;
        this.minimumDelay = minimumDelay;
        this.maximumDelay = maximumDelay;
        this.locked = locked;
        this.powered = powered;
    }

    @Override
    public int getNumericalId() {
        return this.powered ? 94 : 93;
    }

    @Override
    public String getOldStringId() {
        return this.powered ? "minecraft:powered_repeater" : "minecraft:unpowered_repeater";
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public void setDelay(int delay) {
        this.delay = Math.max(this.minimumDelay, Math.min(this.minimumDelay, delay));
    }

    @Override
    public int getMinimumDelay() {
        return this.minimumDelay;
    }

    @Override
    public int getMaximumDelay() {
        return this.maximumDelay;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public Spigot13BlockTypeRepeater clone() {
        return new Spigot13BlockTypeRepeater(this.getFacing(), this.getFaces(), this.delay, this.minimumDelay, this.maximumDelay, this.locked, this.powered);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Repeater) {
            ((Repeater)blockData).setDelay(this.delay);
            ((Repeater)blockData).setPowered(this.powered);
            ((Repeater)blockData).setLocked(this.locked);
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeRepeater readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Repeater) {
            this.delay = ((Repeater)blockData).getDelay();
            this.minimumDelay = ((Repeater)blockData).getMinimumDelay();
            this.maximumDelay = ((Repeater)blockData).getMaximumDelay();
            this.locked = ((Repeater)blockData).isLocked();
            this.powered = ((Repeater)blockData).isPowered();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeRepeater that = (Spigot13BlockTypeRepeater)o;
        return this.delay == that.delay && this.minimumDelay == that.minimumDelay && this.maximumDelay == that.maximumDelay && this.locked == that.locked && this.powered == that.powered;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delay, this.minimumDelay, this.maximumDelay, this.locked, this.powered);
    }
}

