/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumAxis;
import com.degoos.wetsponge.enums.block.EnumBlockTypeQuartzType;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeOrientable;
import com.degoos.wetsponge.material.block.type.WSBlockTypeQuartz;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.data.BlockData;

public class Spigot13BlockTypeQuartz
extends Spigot13BlockTypeOrientable
implements WSBlockTypeQuartz {
    private EnumBlockTypeQuartzType quartzType;

    public Spigot13BlockTypeQuartz(EnumAxis axis, Set<EnumAxis> axes, EnumBlockTypeQuartzType quartzType) {
        super(155, "minecraft:quartz_block", "minecraft:quartz_block", 64, axis, axes);
        Validate.notNull((Object)quartzType, "Quartz type cannot be null!");
        this.quartzType = quartzType;
    }

    @Override
    public String getNewStringId() {
        switch (this.quartzType) {
            case CHISELED: {
                return "minecraft:chiseled_quartz_block";
            }
            case PILLAR: {
                return "minecraft:quartz_pillar";
            }
        }
        return "minecraft:quartz_block";
    }

    @Override
    public EnumBlockTypeQuartzType getQuartzType() {
        return this.quartzType;
    }

    @Override
    public void setQuartzType(EnumBlockTypeQuartzType quartzType) {
        Validate.notNull((Object)quartzType, "Quartz type cannot be null!");
        this.quartzType = quartzType;
    }

    @Override
    public Spigot13BlockTypeQuartz clone() {
        return new Spigot13BlockTypeQuartz(this.getAxis(), this.getAxes(), this.quartzType);
    }

    @Override
    public Spigot13BlockTypeQuartz readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeQuartz that = (Spigot13BlockTypeQuartz)o;
        return this.quartzType == that.quartzType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.quartzType});
    }
}

