/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.EnumInstrument;
import com.degoos.wetsponge.material.block.Spigot13BlockTypePowerable;
import com.degoos.wetsponge.material.block.type.WSBlockTypeNoteBlock;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.NoteBlock;

public class Spigot13BlockTypeNoteBlock
extends Spigot13BlockTypePowerable
implements WSBlockTypeNoteBlock {
    private EnumInstrument instrument;
    private int note;

    public Spigot13BlockTypeNoteBlock(boolean powered, EnumInstrument instrument, int note) {
        super(25, "minecraft:noteblock", "minecraft:note_block", 64, powered);
        Validate.notNull((Object)instrument, "Instrument cannot be null!");
        this.instrument = instrument;
        this.note = Math.max(0, Math.min(25, note));
    }

    @Override
    public EnumInstrument getInstrument() {
        return this.instrument;
    }

    @Override
    public void setInstrument(EnumInstrument instrument) {
        Validate.notNull((Object)instrument, "Instrument cannot be null!");
        this.instrument = instrument;
    }

    @Override
    public int getNote() {
        return this.note;
    }

    @Override
    public void setNote(int note) {
        this.note = Math.max(0, Math.min(25, note));
    }

    @Override
    public Spigot13BlockTypeNoteBlock clone() {
        return new Spigot13BlockTypeNoteBlock(this.isPowered(), this.instrument, this.note);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof NoteBlock) {
            ((NoteBlock)blockData).setInstrument(Instrument.valueOf((String)this.instrument.name()));
            ((NoteBlock)blockData).setNote(new Note(this.note));
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeNoteBlock readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof NoteBlock) {
            this.note = ((NoteBlock)blockData).getNote().getId();
            this.instrument = EnumInstrument.valueOf(((NoteBlock)blockData).getInstrument().name());
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeNoteBlock that = (Spigot13BlockTypeNoteBlock)o;
        return this.note == that.note && this.instrument == that.instrument;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.instrument, this.note});
    }
}

