/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumAxis;
import com.degoos.wetsponge.enums.block.EnumWoodType;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeOrientable;
import com.degoos.wetsponge.material.block.type.WSBlockTypeLog;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.data.BlockData;

public class Spigot13BlockTypeLog
extends Spigot13BlockTypeOrientable
implements WSBlockTypeLog {
    private EnumWoodType woodType;
    private boolean stripped;
    private boolean allFacesCovered;

    public Spigot13BlockTypeLog(EnumAxis axis, Set<EnumAxis> axes, EnumWoodType woodType, boolean stripped, boolean allFacesCovered) {
        super(17, "minecraft:log", "minecraft:log", 64, axis, axes);
        this.woodType = woodType;
        this.stripped = stripped;
        this.allFacesCovered = allFacesCovered;
    }

    @Override
    public int getNumericalId() {
        return this.getWoodType() == EnumWoodType.ACACIA || this.getWoodType() == EnumWoodType.DARK_OAK ? 162 : 17;
    }

    @Override
    public String getOldStringId() {
        return this.getWoodType() == EnumWoodType.ACACIA || this.getWoodType() == EnumWoodType.DARK_OAK ? "minecraft:log2" : "minecraft:log";
    }

    @Override
    public String getNewStringId() {
        return "minecraft:" + (this.stripped ? "stripped_" : "") + this.getWoodType().name().toLowerCase() + (this.allFacesCovered ? "_wood" : "_log");
    }

    @Override
    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    @Override
    public void setWoodType(EnumWoodType woodType) {
        this.woodType = woodType;
    }

    @Override
    public boolean isStripped() {
        return this.stripped;
    }

    @Override
    public void setStripped(boolean stripped) {
        this.stripped = stripped;
    }

    @Override
    public boolean hasAllFacesCovered() {
        return this.allFacesCovered;
    }

    @Override
    public void setAllFacesCovered(boolean allFacesCovered) {
        this.allFacesCovered = allFacesCovered;
    }

    @Override
    public Spigot13BlockTypeLog clone() {
        return new Spigot13BlockTypeLog(this.getAxis(), this.getAxes(), this.woodType, this.stripped, this.allFacesCovered);
    }

    @Override
    public Spigot13BlockTypeLog readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeLog that = (Spigot13BlockTypeLog)o;
        return this.stripped == that.stripped && this.allFacesCovered == that.allFacesCovered && this.woodType == that.woodType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.woodType, this.stripped, this.allFacesCovered});
    }
}

