/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.block.type;

import com.degoos.wetsponge.enums.block.EnumBlockFace;
import com.degoos.wetsponge.material.block.Spigot13BlockTypeMultipleFacing;
import com.degoos.wetsponge.material.block.type.WSBlockTypeFire;
import java.util.Objects;
import java.util.Set;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Fire;

public class Spigot13BlockTypeFire
extends Spigot13BlockTypeMultipleFacing
implements WSBlockTypeFire {
    private int age;
    private int maximumAge;

    public Spigot13BlockTypeFire(Set<EnumBlockFace> faces, Set<EnumBlockFace> allowedFaces, int age, int maximumAge) {
        super(51, "minecraft:fire", "minecraft:fire", 64, faces, allowedFaces);
        this.age = age;
        this.maximumAge = maximumAge;
    }

    @Override
    public int getAge() {
        return this.age;
    }

    @Override
    public void setAge(int age) {
        this.age = Math.min(this.maximumAge, Math.max(0, age));
    }

    @Override
    public int getMaximumAge() {
        return this.maximumAge;
    }

    @Override
    public Spigot13BlockTypeFire clone() {
        return new Spigot13BlockTypeFire(this.getFaces(), this.getAllowedFaces(), this.age, this.maximumAge);
    }

    @Override
    public BlockData toBlockData() {
        BlockData blockData = super.toBlockData();
        if (blockData instanceof Fire) {
            ((Fire)blockData).setAge(this.age);
        }
        return blockData;
    }

    @Override
    public Spigot13BlockTypeFire readBlockData(BlockData blockData) {
        super.readBlockData(blockData);
        if (blockData instanceof Fire) {
            this.age = ((Fire)blockData).getAge();
            this.maximumAge = ((Fire)blockData).getMaximumAge();
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Spigot13BlockTypeFire that = (Spigot13BlockTypeFire)o;
        return this.age == that.age && this.maximumAge == that.maximumAge;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.age, this.maximumAge);
    }
}

